/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.SearchBlockUpdate;
import org.moera.lib.node.types.SearchCommentUpdate;
import org.moera.lib.node.types.SearchContentUpdateType;
import org.moera.lib.node.types.SearchFriendUpdate;
import org.moera.lib.node.types.SearchPostingUpdate;
import org.moera.lib.node.types.SearchReactionUpdate;
import org.moera.lib.node.types.SearchSubscriptionUpdate;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.notifications.SubscriberNotification;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchContentUpdatedNotification
extends SubscriberNotification {
    private SearchContentUpdateType updateType;
    private SearchBlockUpdate blockUpdate;
    private SearchCommentUpdate commentUpdate;
    private SearchFriendUpdate friendUpdate;
    private SearchPostingUpdate postingUpdate;
    private SearchReactionUpdate reactionUpdate;
    private SearchSubscriptionUpdate subscriptionUpdate;

    public SearchContentUpdatedNotification() {
        super(NotificationType.SEARCH_CONTENT_UPDATED);
    }

    public SearchContentUpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(SearchContentUpdateType updateType) {
        this.updateType = updateType;
    }

    public SearchBlockUpdate getBlockUpdate() {
        return this.blockUpdate;
    }

    public void setBlockUpdate(SearchBlockUpdate blockUpdate) {
        this.blockUpdate = blockUpdate;
    }

    public SearchCommentUpdate getCommentUpdate() {
        return this.commentUpdate;
    }

    public void setCommentUpdate(SearchCommentUpdate commentUpdate) {
        this.commentUpdate = commentUpdate;
    }

    public SearchFriendUpdate getFriendUpdate() {
        return this.friendUpdate;
    }

    public void setFriendUpdate(SearchFriendUpdate friendUpdate) {
        this.friendUpdate = friendUpdate;
    }

    public SearchPostingUpdate getPostingUpdate() {
        return this.postingUpdate;
    }

    public void setPostingUpdate(SearchPostingUpdate postingUpdate) {
        this.postingUpdate = postingUpdate;
    }

    public SearchReactionUpdate getReactionUpdate() {
        return this.reactionUpdate;
    }

    public void setReactionUpdate(SearchReactionUpdate reactionUpdate) {
        this.reactionUpdate = reactionUpdate;
    }

    public SearchSubscriptionUpdate getSubscriptionUpdate() {
        return this.subscriptionUpdate;
    }

    public void setSubscriptionUpdate(SearchSubscriptionUpdate subscriptionUpdate) {
        this.subscriptionUpdate = subscriptionUpdate;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notNull((Object)this.updateType, "search.update-type.missing");
        if (this.blockUpdate != null) {
            this.blockUpdate.validate();
        }
        if (this.commentUpdate != null) {
            this.commentUpdate.validate();
        }
        if (this.friendUpdate != null) {
            this.friendUpdate.validate();
        }
        if (this.postingUpdate != null) {
            this.postingUpdate.validate();
        }
        if (this.reactionUpdate != null) {
            this.reactionUpdate.validate();
        }
        if (this.subscriptionUpdate != null) {
            this.subscriptionUpdate.validate();
        }
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("updateType", LogUtil.format(this.updateType.toString())));
    }
}

