/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BodyFormat {
    MESSAGE,
    APPLICATION;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(BodyFormat type) {
        return type != null ? type.getValue() : null;
    }

    public static BodyFormat forValue(String value) {
        try {
            return BodyFormat.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static BodyFormat parse(String value) {
        return BodyFormat.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

