/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.AvatarDescription;
import org.moera.lib.node.types.CommentOperations;
import org.moera.lib.node.types.DraftType;
import org.moera.lib.node.types.PostingOperations;
import org.moera.lib.node.types.RejectedReactions;
import org.moera.lib.node.types.RemoteMedia;
import org.moera.lib.node.types.SourceFormat;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.UpdateInfo;
import org.moera.lib.node.types.body.Body;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DraftText
extends Structure
implements Cloneable {
    private DraftType draftType;
    private String receiverName;
    private String receiverPostingId;
    private String receiverCommentId;
    private String repliedToId;
    private String ownerFullName;
    private AvatarDescription ownerAvatar;
    private RejectedReactions rejectedReactions;
    private RejectedReactions commentRejectedReactions;
    private Body bodySrc;
    private SourceFormat bodySrcFormat;
    private List<RemoteMedia> media;
    private Long publishAt;
    private UpdateInfo updateInfo;
    private PostingOperations operations;
    private CommentOperations commentOperations;

    public DraftType getDraftType() {
        return this.draftType;
    }

    public void setDraftType(DraftType draftType) {
        this.draftType = draftType;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverPostingId() {
        return this.receiverPostingId;
    }

    public void setReceiverPostingId(String receiverPostingId) {
        this.receiverPostingId = receiverPostingId;
    }

    public String getReceiverCommentId() {
        return this.receiverCommentId;
    }

    public void setReceiverCommentId(String receiverCommentId) {
        this.receiverCommentId = receiverCommentId;
    }

    public String getRepliedToId() {
        return this.repliedToId;
    }

    public void setRepliedToId(String repliedToId) {
        this.repliedToId = repliedToId;
    }

    public String getOwnerFullName() {
        return this.ownerFullName;
    }

    public void setOwnerFullName(String ownerFullName) {
        this.ownerFullName = ownerFullName;
    }

    public AvatarDescription getOwnerAvatar() {
        return this.ownerAvatar;
    }

    public void setOwnerAvatar(AvatarDescription ownerAvatar) {
        this.ownerAvatar = ownerAvatar;
    }

    public RejectedReactions getRejectedReactions() {
        return this.rejectedReactions;
    }

    public void setRejectedReactions(RejectedReactions rejectedReactions) {
        this.rejectedReactions = rejectedReactions;
    }

    public RejectedReactions getCommentRejectedReactions() {
        return this.commentRejectedReactions;
    }

    public void setCommentRejectedReactions(RejectedReactions commentRejectedReactions) {
        this.commentRejectedReactions = commentRejectedReactions;
    }

    public Body getBodySrc() {
        return this.bodySrc;
    }

    public void setBodySrc(Body bodySrc) {
        this.bodySrc = bodySrc;
    }

    public SourceFormat getBodySrcFormat() {
        return this.bodySrcFormat;
    }

    public void setBodySrcFormat(SourceFormat bodySrcFormat) {
        this.bodySrcFormat = bodySrcFormat;
    }

    public List<RemoteMedia> getMedia() {
        return this.media;
    }

    public void setMedia(List<RemoteMedia> media) {
        this.media = media;
    }

    public Long getPublishAt() {
        return this.publishAt;
    }

    public void setPublishAt(Long publishAt) {
        this.publishAt = publishAt;
    }

    public UpdateInfo getUpdateInfo() {
        return this.updateInfo;
    }

    public void setUpdateInfo(UpdateInfo updateInfo) {
        this.updateInfo = updateInfo;
    }

    public PostingOperations getOperations() {
        return this.operations;
    }

    public void setOperations(PostingOperations operations) {
        this.operations = operations;
    }

    public CommentOperations getCommentOperations() {
        return this.commentOperations;
    }

    public void setCommentOperations(CommentOperations commentOperations) {
        this.commentOperations = commentOperations;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notBlank(this.receiverName, "draft.receiver-name.blank");
        ValidationUtil.maxSize(this.receiverName, 63, "draft.receiver-name.wrong-size");
        ValidationUtil.maxSize(this.receiverPostingId, 40, "draft.receiver-posting-id.wrong-size");
        ValidationUtil.maxSize(this.receiverCommentId, 40, "draft.receiver-comment-id.wrong-size");
        ValidationUtil.maxSize(this.repliedToId, 40, "draft.replied-to-id.wrong-size");
        ValidationUtil.maxSize(this.ownerFullName, 96, "draft.owner-full-name.wrong-size");
        if (this.rejectedReactions != null) {
            this.rejectedReactions.validate();
        }
        if (this.commentRejectedReactions != null) {
            this.commentRejectedReactions.validate();
        }
        if (this.updateInfo != null) {
            this.updateInfo.validate();
        }
    }

    public DraftText clone() {
        try {
            return (DraftText)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

