/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class EmojiList {
    public static final Set<Integer> STANDARD_POSITIVE = Set.of(128161, 128077, 128175, 128525, 128512, 129318, 128558, 128546, 128544, 129326, 128142, 127871, 128555, 128157, 128557, 129528, 9992, 127865, 128591, 128524, 129730, 128293, 129315, 129392, 129393, 128561);
    public static final Set<Integer> STANDARD_NEGATIVE = Set.of(128164, 128078, 128169, 9876, 9203, 127913, 128579, 128540, 128148, 128127, 129414, 10060, 129412, 129519, 128405);
    private static final Pattern PATTERN = Pattern.compile("^\\s*(?:\\p{XDigit}+|\\*)?(?:\\s+(?:\\p{XDigit}+|\\*))*\\s*$");
    private Set<Integer> rejected = Collections.emptySet();
    private boolean other;

    public EmojiList() {
    }

    public EmojiList(String s) {
        String[] parts = s.split(" ");
        this.other = Arrays.stream(parts).map(String::trim).anyMatch(p -> p.equals("*"));
        if (!this.other) {
            this.rejected = Arrays.stream(parts).map(String::trim).filter(p -> !p.isEmpty()).filter(p -> !p.equals("*")).map(p -> Integer.parseInt(p, 16)).collect(Collectors.toSet());
        }
    }

    public boolean isAccepted(int emoji, boolean negative) {
        if (this.rejected.contains(emoji)) {
            return false;
        }
        if (!this.other) {
            return true;
        }
        return !negative ? STANDARD_POSITIVE.contains(emoji) : STANDARD_NEGATIVE.contains(emoji);
    }

    public static boolean isValid(String s) {
        return PATTERN.matcher(s).matches();
    }

    public static String combine(String first, String second) {
        if (first == null || first.isBlank()) {
            return second;
        }
        if (second == null || second.isBlank()) {
            return first;
        }
        EmojiList firstList = new EmojiList(first);
        EmojiList secondList = new EmojiList(second);
        firstList.rejected.addAll(secondList.rejected);
        firstList.other = firstList.other || secondList.other;
        return firstList.toString();
    }

    public String toString() {
        String base = this.rejected.stream().map(Integer::toHexString).collect(Collectors.joining(" "));
        if (this.other) {
            return base.isEmpty() ? "*" : base + " *";
        }
        return base;
    }
}

