/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SearchEntryType {
    ALL,
    POSTING,
    COMMENT;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(SearchEntryType type) {
        return type != null ? type.getValue() : null;
    }

    public static SearchEntryType forValue(String value) {
        try {
            return SearchEntryType.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static SearchEntryType parse(String value) {
        return SearchEntryType.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

