/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.SearchEntryType;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchHashtagFilter
extends Structure
implements Cloneable {
    private SearchEntryType entryType;
    private List<String> hashtags;
    private String publisherName;
    private Boolean inNewsfeed;
    private List<String> owners;
    private Integer minImageCount;
    private Integer maxImageCount;
    private Boolean videoPresent;
    private String sheriffName;
    private Long after;
    private Long before;
    private Integer limit;

    public SearchEntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(SearchEntryType entryType) {
        this.entryType = entryType;
    }

    public List<String> getHashtags() {
        return this.hashtags;
    }

    public void setHashtags(List<String> hashtags) {
        this.hashtags = hashtags;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public void setPublisherName(String publisherName) {
        this.publisherName = publisherName;
    }

    public Boolean getInNewsfeed() {
        return this.inNewsfeed;
    }

    public void setInNewsfeed(Boolean inNewsfeed) {
        this.inNewsfeed = inNewsfeed;
    }

    public List<String> getOwners() {
        return this.owners;
    }

    public void setOwners(List<String> owners) {
        this.owners = owners;
    }

    public Integer getMinImageCount() {
        return this.minImageCount;
    }

    public void setMinImageCount(Integer minImageCount) {
        this.minImageCount = minImageCount;
    }

    public Integer getMaxImageCount() {
        return this.maxImageCount;
    }

    public void setMaxImageCount(Integer maxImageCount) {
        this.maxImageCount = maxImageCount;
    }

    public Boolean getVideoPresent() {
        return this.videoPresent;
    }

    public void setVideoPresent(Boolean videoPresent) {
        this.videoPresent = videoPresent;
    }

    public String getSheriffName() {
        return this.sheriffName;
    }

    public void setSheriffName(String sheriffName) {
        this.sheriffName = sheriffName;
    }

    public Long getAfter() {
        return this.after;
    }

    public void setAfter(Long after) {
        this.after = after;
    }

    public Long getBefore() {
        return this.before;
    }

    public void setBefore(Long before) {
        this.before = before;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notNull(this.hashtags, "search.hashtags.missing");
        ValidationUtil.minItems(this.hashtags, 1, "search.hashtags.missing");
        ValidationUtil.maxItems(this.hashtags, 16, "search.hashtags.too-many");
        ValidationUtil.maxItems(this.owners, 16, "search.owners.too-many");
        ValidationUtil.minValue(this.minImageCount, 0, "search.min-image-count.invalid");
        ValidationUtil.minValue(this.maxImageCount, 0, "search.max-image-count.invalid");
        ValidationUtil.minValue(this.limit, 0, "limit.invalid");
    }

    public SearchHashtagFilter clone() {
        try {
            return (SearchHashtagFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

