/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.node.types.AskSubject;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AskedNotification
extends Notification {
    private AskSubject subject;
    private String friendGroupId;
    private String message;

    public AskedNotification() {
        super(NotificationType.ASKED);
    }

    public AskSubject getSubject() {
        return this.subject;
    }

    public void setSubject(AskSubject subject) {
        this.subject = subject;
    }

    public String getFriendGroupId() {
        return this.friendGroupId;
    }

    public void setFriendGroupId(String friendGroupId) {
        this.friendGroupId = friendGroupId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.friendGroupId, 40, "ask.friend-group-id.wrong-size");
        ValidationUtil.maxSize(this.message, 70, "ask.message.wrong-size");
    }
}

