/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.moera.lib.node.types.AvatarImage;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.util.Util;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Notification
implements Cloneable {
    @JsonIgnore
    private String senderNodeName;
    @JsonIgnore
    private String senderFullName;
    @JsonIgnore
    private String senderGender;
    @JsonIgnore
    private AvatarImage senderAvatar;
    @JsonIgnore
    private NotificationType type;
    @JsonIgnore
    private String pendingNotificationId;
    @JsonIgnore
    private Timestamp createdAt = Util.now();

    protected Notification(NotificationType type) {
        this.type = type;
    }

    public String getSenderNodeName() {
        return this.senderNodeName;
    }

    public void setSenderNodeName(String senderNodeName) {
        this.senderNodeName = senderNodeName;
    }

    public String getSenderFullName() {
        return this.senderFullName;
    }

    public void setSenderFullName(String senderFullName) {
        this.senderFullName = senderFullName;
    }

    public String getSenderGender() {
        return this.senderGender;
    }

    public void setSenderGender(String senderGender) {
        this.senderGender = senderGender;
    }

    public AvatarImage getSenderAvatar() {
        return this.senderAvatar;
    }

    public void setSenderAvatar(AvatarImage senderAvatar) {
        this.senderAvatar = senderAvatar;
    }

    public NotificationType getType() {
        return this.type;
    }

    public void setType(NotificationType type) {
        this.type = type;
    }

    public String getPendingNotificationId() {
        return this.pendingNotificationId;
    }

    public void setPendingNotificationId(String pendingNotificationId) {
        this.pendingNotificationId = pendingNotificationId;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public void validate() {
    }

    public Notification clone() {
        try {
            return (Notification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }

    public final String toLogMessage() {
        ArrayList<LogPair> parameters = new ArrayList<LogPair>();
        this.logParameters(parameters);
        if (parameters.isEmpty()) {
            return this.getType().toString();
        }
        String params = parameters.stream().map(p -> p.name() + " = " + p.value()).collect(Collectors.joining(", "));
        return "%s (%s)".formatted(new Object[]{this.getType(), params});
    }

    public void logParameters(List<LogPair> parameters) {
    }
}

