/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.AvatarImage;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PostingReactionDeletedNotification
extends Notification {
    private String parentPostingId;
    private String parentCommentId;
    private String parentMediaId;
    private String postingId;
    private String ownerName;
    private String ownerFullName;
    private String ownerGender;
    private AvatarImage ownerAvatar;
    private boolean negative;

    public PostingReactionDeletedNotification() {
        super(NotificationType.POSTING_REACTION_DELETED);
    }

    public String getParentPostingId() {
        return this.parentPostingId;
    }

    public void setParentPostingId(String parentPostingId) {
        this.parentPostingId = parentPostingId;
    }

    public String getParentCommentId() {
        return this.parentCommentId;
    }

    public void setParentCommentId(String parentCommentId) {
        this.parentCommentId = parentCommentId;
    }

    public String getParentMediaId() {
        return this.parentMediaId;
    }

    public void setParentMediaId(String parentMediaId) {
        this.parentMediaId = parentMediaId;
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerFullName() {
        return this.ownerFullName;
    }

    public void setOwnerFullName(String ownerFullName) {
        this.ownerFullName = ownerFullName;
    }

    public String getOwnerGender() {
        return this.ownerGender;
    }

    public void setOwnerGender(String ownerGender) {
        this.ownerGender = ownerGender;
    }

    public AvatarImage getOwnerAvatar() {
        return this.ownerAvatar;
    }

    public void setOwnerAvatar(AvatarImage ownerAvatar) {
        this.ownerAvatar = ownerAvatar;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.parentPostingId, 40, "reaction.parent-posting-id.wrong-size");
        ValidationUtil.maxSize(this.parentCommentId, 40, "reaction.parent-comment-id.wrong-size");
        ValidationUtil.maxSize(this.parentMediaId, 40, "reaction.parent-media-id.wrong-size");
        ValidationUtil.maxSize(this.postingId, 40, "reaction.posting-id.wrong-size");
        ValidationUtil.maxSize(this.ownerName, 63, "reaction.owner-name.wrong-size");
        ValidationUtil.maxSize(this.ownerFullName, 96, "reaction.owner-full-name.wrong-size");
        ValidationUtil.maxSize(this.ownerGender, 31, "reaction.owner-gender.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("parentPostingId", LogUtil.format(this.parentPostingId)));
        parameters.add(LogPair.of("parentCommentId", LogUtil.format(this.parentCommentId)));
        parameters.add(LogPair.of("parentMediaId", LogUtil.format(this.parentMediaId)));
        parameters.add(LogPair.of("postingId", LogUtil.format(this.postingId)));
        parameters.add(LogPair.of("ownerName", LogUtil.format(this.ownerName)));
    }
}

