/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.principal;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.moera.lib.node.types.principal.PrincipalExpression;
import org.moera.lib.node.types.principal.PrincipalFilter;
import org.moera.lib.node.types.principal.UnresolvedPrincipalException;

@JsonSerialize(converter=ToStringConverter.class)
@JsonDeserialize(converter=FromStringConverter.class)
public class Principal
implements Cloneable,
PrincipalFilter {
    public static final Principal NONE = new Principal("none");
    public static final Principal ADMIN = new Principal("admin");
    public static final Principal SIGNED = new Principal("signed");
    public static final Principal SUBSCRIBED = new Principal("subscribed");
    public static final Principal PRIVATE = new Principal("private");
    public static final Principal SECRET = new Principal("secret");
    public static final Principal SENIOR = new Principal("senior");
    public static final Principal ENIGMA = new Principal("enigma");
    public static final Principal MAJOR = new Principal("major");
    public static final Principal OWNER = new Principal("owner");
    public static final Principal PUBLIC = new Principal("public");
    public static final Principal UNSET = new Principal("unset");
    private static final Map<Principal, Integer> PRINCIPAL_MASKS = Map.of(PRIVATE, 15, SECRET, 13, SENIOR, 14, ENIGMA, 9, MAJOR, 12, OWNER, 1, ADMIN, 8, NONE, 0);
    private final String value;

    public Principal(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Principal cannot be null");
        }
        this.value = value;
    }

    public static Principal ofNode(String ... nodeNames) {
        return new Principal("node:" + Principal.joinNotNull(",", nodeNames));
    }

    public static Principal ofOnly(String ... nodeNames) {
        return new Principal("only:" + Principal.joinNotNull(",", nodeNames));
    }

    public static Principal ofFriendGroup(String friendGroupName) {
        return new Principal("f:" + friendGroupName);
    }

    private static String joinNotNull(String delimiter, String[] names) {
        StringBuilder result = new StringBuilder();
        for (String name : names) {
            if (name == null) continue;
            if (!result.isEmpty()) {
                result.append(delimiter);
            }
            result.append(name);
        }
        return result.toString();
    }

    public String getValue() {
        return this.value;
    }

    public boolean isNone() {
        return this.value.equals(Principal.NONE.value);
    }

    public boolean isAdmin() {
        return this.value.equals(Principal.ADMIN.value);
    }

    public boolean isSigned() {
        return this.value.equals(Principal.SIGNED.value);
    }

    public boolean isSubscribed() {
        return this.value.equals(Principal.SUBSCRIBED.value);
    }

    public boolean isPrivate() {
        return this.value.equals(Principal.PRIVATE.value);
    }

    public boolean isSecret() {
        return this.value.equals(Principal.SECRET.value);
    }

    public boolean isSenior() {
        return this.value.equals(Principal.SENIOR.value);
    }

    public boolean isEnigma() {
        return this.value.equals(Principal.ENIGMA.value);
    }

    public boolean isMajor() {
        return this.value.equals(Principal.MAJOR.value);
    }

    public boolean isOwner() {
        return this.value.equals(Principal.OWNER.value);
    }

    public boolean isPublic() {
        return this.value.equals(Principal.PUBLIC.value);
    }

    public boolean isUnset() {
        return this.value.equals(Principal.UNSET.value);
    }

    public boolean isNode() {
        return this.value.startsWith("node:");
    }

    public boolean isOnly() {
        return this.value.startsWith("only:");
    }

    public boolean isFriends() {
        return this.value.startsWith("f:");
    }

    public String[] getNodeNames() {
        return this.isNode() || this.isOnly() ? this.value.substring(5).split(",") : new String[]{};
    }

    public String getFriendGroupId() {
        return this.isFriends() ? this.value.substring(2) : null;
    }

    public Principal withOwner(String ownerName) {
        if (this.isOwner()) {
            return Principal.ofOnly(ownerName);
        }
        if (this.isPrivate() | this.isSecret() | this.isEnigma()) {
            return Principal.ofNode(ownerName);
        }
        if (this.isSenior() | this.isMajor()) {
            return ADMIN;
        }
        return this;
    }

    public Principal withOwner(String ownerName, String seniorName) {
        if (this.isOwner()) {
            return Principal.ofOnly(ownerName);
        }
        if (this.isPrivate()) {
            return Principal.ofNode(ownerName, seniorName);
        }
        if (this.isSecret() | this.isEnigma()) {
            return Principal.ofNode(ownerName);
        }
        if (this.isSenior()) {
            return Principal.ofNode(seniorName);
        }
        if (this.isMajor()) {
            return ADMIN;
        }
        return this;
    }

    public Principal withOwner(String ownerName, String seniorName, String majorName) {
        if (this.isOwner()) {
            return Principal.ofOnly(ownerName);
        }
        if (this.isPrivate()) {
            return Principal.ofNode(ownerName, seniorName, majorName);
        }
        if (this.isSecret()) {
            return Principal.ofNode(ownerName, majorName);
        }
        if (this.isSenior()) {
            return Principal.ofNode(seniorName, majorName);
        }
        if (this.isEnigma()) {
            return Principal.ofNode(ownerName);
        }
        if (this.isMajor()) {
            return Principal.ofNode(majorName);
        }
        return this;
    }

    public Principal withSubordinate(Principal principal) {
        return this.isUnset() ? principal : this;
    }

    public boolean equals(Object peer) {
        if (this == peer) {
            return true;
        }
        if (peer == null || this.getClass() != peer.getClass()) {
            return false;
        }
        Principal principal = (Principal)peer;
        return this.value.equals(principal.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    protected Principal clone() {
        return new Principal(this.value);
    }

    @Override
    public boolean includes(boolean admin, String nodeName, boolean subscribed, String[] friendGroups) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isNone()) {
            return false;
        }
        if (this.isOnly()) {
            return Principal.includes(this.getNodeNames(), nodeName);
        }
        if (admin) {
            return true;
        }
        if (this.isAdmin()) {
            return false;
        }
        if (this.isSigned()) {
            return nodeName != null;
        }
        if (this.isSubscribed()) {
            return subscribed;
        }
        if (this.isNode()) {
            return Principal.includes(this.getNodeNames(), nodeName);
        }
        if (this.isFriends()) {
            return friendGroups != null && Principal.includes(friendGroups, this.getFriendGroupId());
        }
        throw new UnresolvedPrincipalException(this);
    }

    public boolean includes(boolean admin, String nodeName, Supplier<Boolean> subscribed, Supplier<String[]> friendGroups) {
        return this.includes(admin, nodeName, this.isSubscribed() ? subscribed.get() : false, this.isFriends() ? friendGroups.get() : null);
    }

    private static boolean includes(String[] names, String name) {
        if (names == null || names.length == 0 || name == null) {
            return false;
        }
        for (String s : names) {
            if (!Objects.equals(s, name)) continue;
            return true;
        }
        return false;
    }

    public boolean isOneOf(int flags) {
        if (this.isNone()) {
            return (flags & 1) != 0;
        }
        if (this.isAdmin()) {
            return (flags & 2) != 0;
        }
        if (this.isSigned()) {
            return (flags & 4) != 0;
        }
        if (this.isPrivate()) {
            return (flags & 8) != 0;
        }
        if (this.isSecret()) {
            return (flags & 0x200) != 0;
        }
        if (this.isSenior()) {
            return (flags & 0x400) != 0;
        }
        if (this.isEnigma()) {
            return (flags & 0x800) != 0;
        }
        if (this.isMajor()) {
            return (flags & 0x1000) != 0;
        }
        if (this.isOwner()) {
            return (flags & 0x10) != 0;
        }
        if (this.isPublic()) {
            return (flags & 0x20) != 0;
        }
        if (this.isUnset()) {
            return (flags & 0x100) != 0;
        }
        if (this.isNode()) {
            return (flags & 0x40) != 0;
        }
        if (this.isOnly()) {
            return (flags & 0x80) != 0;
        }
        if (this.isFriends()) {
            return (flags & 0x2000) != 0;
        }
        if (this.isSubscribed()) {
            return (flags & 0x4000) != 0;
        }
        return false;
    }

    public Principal union(Principal principal) {
        if (this.isUnset()) {
            return principal;
        }
        if (this.isPublic() || principal.isPublic()) {
            return PUBLIC;
        }
        if (this.isSigned() || principal.isSigned()) {
            return SIGNED;
        }
        if (this.isSubscribed() || principal.isSubscribed()) {
            return SUBSCRIBED;
        }
        if (this.isFriends() && principal.isFriends()) {
            return SIGNED;
        }
        if (this.isFriends()) {
            return this;
        }
        if (principal.isFriends()) {
            return principal;
        }
        Integer mask = PRINCIPAL_MASKS.get(this);
        Integer principalMask = PRINCIPAL_MASKS.get(principal);
        return mask != null && principalMask != null ? this.closeToMask(mask | principalMask) : NONE;
    }

    public Principal intersect(Principal principal) {
        if (this.isUnset()) {
            return principal;
        }
        if (this.isPublic()) {
            return principal;
        }
        if (principal.isPublic()) {
            return this;
        }
        if (this.isSigned()) {
            return principal;
        }
        if (principal.isSigned()) {
            return this;
        }
        if (this.isSubscribed()) {
            return principal;
        }
        if (principal.isSubscribed()) {
            return this;
        }
        if (this.isFriends()) {
            return principal;
        }
        if (principal.isFriends()) {
            return this;
        }
        Integer mask = PRINCIPAL_MASKS.get(this);
        Integer principalMask = PRINCIPAL_MASKS.get(principal);
        return mask != null && principalMask != null ? this.closeToMask(mask & principalMask) : NONE;
    }

    private Principal closeToMask(int mask) {
        Principal closest = null;
        int closeness = 256;
        for (Map.Entry<Principal, Integer> entry : PRINCIPAL_MASKS.entrySet()) {
            int c = Integer.bitCount(entry.getValue() ^ mask);
            if (c >= closeness) continue;
            closest = entry.getKey();
            closeness = c;
        }
        return closest;
    }

    @Override
    public PrincipalExpression a() {
        return PrincipalExpression.by(this);
    }

    public PrincipalExpression not() {
        return PrincipalExpression.byNot(this);
    }

    public static class FromStringConverter
    extends StdConverter<String, Principal> {
        public Principal convert(String s) {
            return new Principal(s);
        }
    }

    public static class ToStringConverter
    extends StdConverter<Principal, String> {
        public String convert(Principal principal) {
            return principal.getValue();
        }
    }
}

