/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.principal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PrincipalFlag {
    public static final int NONE = 1;
    public static final int ADMIN = 2;
    public static final int SIGNED = 4;
    public static final int PRIVATE = 8;
    public static final int OWNER = 16;
    public static final int PUBLIC = 32;
    public static final int NODE = 64;
    public static final int ONLY = 128;
    public static final int UNSET = 256;
    public static final int SECRET = 512;
    public static final int SENIOR = 1024;
    public static final int ENIGMA = 2048;
    public static final int MAJOR = 4096;
    public static final int FRIENDS = 8192;
    public static final int SUBSCRIBED = 16384;
    public static final Map<String, Integer> NAMES = new HashMap<String, Integer>();

    public static int fromName(String name) {
        Integer flag = NAMES.get(name);
        if (flag == null) {
            throw new IllegalArgumentException("Unknown principal flag name");
        }
        return flag;
    }

    public static int fromNames(Collection<String> names) {
        int flags = 0;
        for (String name : names) {
            flags |= PrincipalFlag.fromName(name);
        }
        return flags;
    }

    static {
        NAMES.put("none", 1);
        NAMES.put("admin", 2);
        NAMES.put("signed", 4);
        NAMES.put("private", 8);
        NAMES.put("owner", 16);
        NAMES.put("public", 32);
        NAMES.put("node", 64);
        NAMES.put("only", 128);
        NAMES.put("unset", 256);
        NAMES.put("secret", 512);
        NAMES.put("senior", 1024);
        NAMES.put("enigma", 2048);
        NAMES.put("major", 4096);
        NAMES.put("friends", 8192);
        NAMES.put("subscribed", 16384);
    }
}

