/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis;

import java.util.HashSet;
import java.util.Set;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class DirectAndIndirectTermAnnotations {
    private final TermId ontologyId;
    private final Set<TermId> directAnnotatedDomainItemSet;
    private final Set<TermId> totalAnnotatedDomainItemSet;

    public DirectAndIndirectTermAnnotations(TermId ontologyTermId) {
        this.ontologyId = ontologyTermId;
        this.directAnnotatedDomainItemSet = new HashSet<TermId>();
        this.totalAnnotatedDomainItemSet = new HashSet<TermId>();
    }

    public void addDirectAnnotatedItem(TermId domainItemId) {
        this.directAnnotatedDomainItemSet.add(domainItemId);
        this.totalAnnotatedDomainItemSet.add(domainItemId);
    }

    public TermId getOntologyId() {
        return this.ontologyId;
    }

    public void addIndirectAnnotatedItem(TermId domainItemId) {
        this.totalAnnotatedDomainItemSet.add(domainItemId);
    }

    public int directAnnotatedCount() {
        return this.directAnnotatedDomainItemSet.size();
    }

    public int totalAnnotatedCount() {
        return this.totalAnnotatedDomainItemSet.size();
    }

    public Set<TermId> getDirectAnnotatedDomainItemSet() {
        return this.directAnnotatedDomainItemSet;
    }

    public Set<TermId> getTotalAnnotatedDomainItemSet() {
        return this.totalAnnotatedDomainItemSet;
    }
}

