/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.monarchinitiative.phenol.analysis.AssociationContainer;
import org.monarchinitiative.phenol.analysis.DirectAndIndirectTermAnnotations;
import org.monarchinitiative.phenol.analysis.GeneAnnotations;
import org.monarchinitiative.phenol.analysis.ItemAnnotations;
import org.monarchinitiative.phenol.analysis.StudySet;
import org.monarchinitiative.phenol.analysis.util.Util;
import org.monarchinitiative.phenol.annotations.formats.go.GoGaf22Annotation;
import org.monarchinitiative.phenol.annotations.io.go.GoGeneAnnotationParser;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoAssociationContainer
implements AssociationContainer<TermId> {
    private final Logger LOGGER = LoggerFactory.getLogger(GoAssociationContainer.class);
    private static final TermId fakeRoot = TermId.of((String)"owl:Thing");
    private final List<GoGaf22Annotation> rawAssociations;
    private final Map<TermId, GeneAnnotations> gene2associationMap;
    private final Ontology ontology;
    private final int annotatingTermCount;

    private GoAssociationContainer(Ontology ontology, List<GoGaf22Annotation> rawAssociations, Map<TermId, GeneAnnotations> gene2associationMap, int annotatingTermCount) {
        this.ontology = ontology;
        this.rawAssociations = rawAssociations;
        this.gene2associationMap = gene2associationMap;
        this.annotatingTermCount = annotatingTermCount;
    }

    @Override
    public int getAnnotatingTermCount() {
        return this.annotatingTermCount;
    }

    @Override
    public int getTotalAnnotationCount() {
        return this.rawAssociations.size();
    }

    @Override
    public Map<TermId, List<TermId>> getOntologyTermToDomainItemsMap() {
        HashMap<TermId, List<TermId>> mp = new HashMap<TermId, List<TermId>>();
        for (Map.Entry<TermId, GeneAnnotations> entry : this.gene2associationMap.entrySet()) {
            TermId gene = entry.getKey();
            for (TermId ontologyTermId : entry.getValue().getAnnotatingTermIds()) {
                mp.computeIfAbsent(ontologyTermId, key -> new ArrayList()).add(gene);
            }
        }
        return mp;
    }

    public List<GoGaf22Annotation> getRawAssociations() {
        return this.rawAssociations;
    }

    @Override
    public Set<TermId> getAllAnnotatedGenes() {
        return this.gene2associationMap.keySet();
    }

    @Override
    public Set<TermId> getDomainItemsAnnotatedByOntologyTerm(TermId tid) {
        return Util.getDomainItemsAnnotatedByOntologyTerm(tid, (MinimalOntology)this.ontology, this.gene2associationMap);
    }

    public int getTotalNumberOfAnnotatedItems() {
        return this.gene2associationMap.size();
    }

    @Override
    public Map<TermId, DirectAndIndirectTermAnnotations> getAssociationMap(Set<TermId> annotatedItemTermIds) {
        return this.getAssociationMap(annotatedItemTermIds, false);
    }

    public Map<TermId, DirectAndIndirectTermAnnotations> getAssociationMap(Set<TermId> annotatedItemTermIds, boolean verbose) {
        HashMap<TermId, Set> directAnnotationMap = new HashMap<TermId, Set>();
        int not_found = 0;
        for (TermId domainTermId : annotatedItemTermIds) {
            if (!this.gene2associationMap.containsKey(domainTermId)) {
                this.LOGGER.error("Could not find annotations for  {}", (Object)domainTermId.getValue());
                continue;
            }
            GeneAnnotations assocs = this.gene2associationMap.get(domainTermId);
            for (TermAnnotation termAnnotation : assocs.getAnnotations()) {
                TermId ontologyTermId = termAnnotation.id();
                if (this.ontology.termForTermId(ontologyTermId).isEmpty()) {
                    ++not_found;
                    if (!verbose) continue;
                    this.LOGGER.warn("[WARNING(phenol:AssociationContainer)] Unable to retrieve term {} (omitted).", (Object)ontologyTermId.getValue());
                    continue;
                }
                ontologyTermId = this.ontology.getPrimaryTermId(ontologyTermId);
                directAnnotationMap.computeIfAbsent(domainTermId, k -> new HashSet()).add(ontologyTermId);
            }
        }
        if (not_found > 0) {
            this.LOGGER.warn("Cound not find annotations for {} ontology term ids (are versions in synch?)", (Object)not_found);
        }
        HashMap<TermId, DirectAndIndirectTermAnnotations> annotationMap = new HashMap<TermId, DirectAndIndirectTermAnnotations>();
        for (Map.Entry entry : directAnnotationMap.entrySet()) {
            TermId domainItemTermId = (TermId)entry.getKey();
            for (TermId ontologyId : (Set)entry.getValue()) {
                annotationMap.computeIfAbsent(ontologyId, DirectAndIndirectTermAnnotations::new).addDirectAnnotatedItem(domainItemTermId);
                Set ancs = OntologyAlgorithm.getAncestorTerms((Ontology)this.ontology, (TermId)ontologyId, (boolean)false);
                for (TermId ancestor : ancs) {
                    annotationMap.computeIfAbsent(ancestor, DirectAndIndirectTermAnnotations::new).addIndirectAnnotatedItem(domainItemTermId);
                }
            }
        }
        return Map.copyOf(annotationMap);
    }

    public StudySet fromGeneSymbols(Set<String> geneSymbols, String label) {
        HashMap<String, TermId> symbolToTermIdMap = new HashMap<String, TermId>();
        for (GoGaf22Annotation annot : this.rawAssociations) {
            String symbol = annot.getDbObjectSymbol();
            TermId tid = annot.getDbObjectTermId();
            symbolToTermIdMap.putIfAbsent(symbol, tid);
        }
        HashSet<TermId> studyTermIds = new HashSet<TermId>();
        HashSet<String> unmappableSymbols = new HashSet<String>();
        for (String symbol : geneSymbols) {
            if (symbolToTermIdMap.containsKey(symbol)) {
                studyTermIds.add((TermId)symbolToTermIdMap.get(symbol));
                continue;
            }
            unmappableSymbols.add(symbol);
        }
        return new StudySet(label, this.getAssociationMap(studyTermIds), unmappableSymbols);
    }

    public StudySet fromGeneIds(Set<TermId> geneIds, String label) {
        return new StudySet(label, this.getAssociationMap(geneIds));
    }

    public static GoAssociationContainer loadGoGafAssociationContainer(Path goGafFile, Ontology ontology) {
        List goAnnots = GoGeneAnnotationParser.loadAnnotations((Path)goGafFile);
        return GoAssociationContainer.fromGoTermAnnotations(goAnnots, ontology);
    }

    public static GoAssociationContainer fromGoTermAnnotations(List<GoGaf22Annotation> goTermAnnotations, Ontology ontology) {
        HashMap<TermId, Set> annotationsBuilder = new HashMap<TermId, Set>();
        for (TermAnnotation termAnnotation : goTermAnnotations) {
            TermId tid = termAnnotation.getItemId();
            if (tid.equals((Object)fakeRoot)) continue;
            annotationsBuilder.computeIfAbsent(tid, annotatedGene -> new HashSet()).add(termAnnotation);
        }
        HashMap tempMap = new HashMap();
        annotationsBuilder.forEach((k, v) -> tempMap.put(k, GeneAnnotations.of(k, List.copyOf(v))));
        Map<TermId, GeneAnnotations> map = Map.copyOf(tempMap);
        long size = map.values().stream().map(ItemAnnotations::getAnnotatingTermIds).distinct().count();
        return new GoAssociationContainer(ontology, goTermAnnotations, map, Math.toIntExact(size));
    }
}

