/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.mgsa;

import org.monarchinitiative.phenol.analysis.mgsa.MgsaParam;

class IntegerParam
extends MgsaParam {
    private int val;

    public IntegerParam(MgsaParam.Type type, int val) {
        super(type);
        this.val = val;
    }

    public IntegerParam(MgsaParam.Type type) {
        super(type);
        if (type == MgsaParam.Type.FIXED) {
            throw new IllegalArgumentException("Parameter could not be instantiated of type Fixed.");
        }
    }

    public IntegerParam(IntegerParam p) {
        super(p);
        this.val = p.val;
    }

    int getValue() {
        return this.val;
    }

    void setValue(int newVal) {
        this.val = newVal;
        this.setType(MgsaParam.Type.FIXED);
    }

    public String toString() {
        if (this.isFixed()) {
            return Integer.toString(this.val);
        }
        return this.getType().toString();
    }
}

