/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.mgsa;

import java.util.ArrayList;
import java.util.List;
import org.monarchinitiative.phenol.analysis.GoAssociationContainer;
import org.monarchinitiative.phenol.analysis.StudySet;
import org.monarchinitiative.phenol.analysis.mgsa.MgsaGOTermResult;
import org.monarchinitiative.phenol.analysis.mgsa.MgsaScore;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;

public class MgsaGOTermsResultContainer {
    private MgsaScore score;
    protected final List<MgsaGOTermResult> list = new ArrayList<MgsaGOTermResult>();
    protected final Ontology go;
    private final GoAssociationContainer associations;
    private final int populationGeneCount;
    private final StudySet studySet;

    public MgsaGOTermsResultContainer(Ontology go, GoAssociationContainer associations, StudySet studySet, int populationGeneCount) {
        this.go = go;
        this.associations = associations;
        this.studySet = studySet;
        this.populationGeneCount = populationGeneCount;
    }

    public void addGOTermProperties(MgsaGOTermResult prop) {
        if (prop.getTermId() == null) {
            throw new IllegalArgumentException("prop.term mustn't be null");
        }
        this.list.add(prop);
    }

    public void dumpToShell() {
        System.out.println("[INFO] Terms with marginal probability above 1%");
        for (MgsaGOTermResult agtp : this.list) {
            double d = agtp.getMarg();
            if (agtp.getAnnotatedStudyGenes() < 2 || d < 0.01) continue;
            ArrayList<String> items = new ArrayList<String>();
            items.add(agtp.getTermId().getValue());
            items.add(this.go.termForTermId(agtp.getTermId()).map(Term::getName).orElse(null));
            items.add(String.format("%d/%d (%.1f%%)", agtp.getAnnotatedStudyGenes(), agtp.getAnnotatedPopulationGenes(), 100.0 * (double)agtp.getAnnotatedStudyGenes() / (double)agtp.getAnnotatedPopulationGenes()));
            items.add(String.format("%f", agtp.getMarg()));
            System.out.println(String.join((CharSequence)"\t", items));
        }
    }
}

