/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.mgsa;

public abstract class MgsaScoreBase {
    private boolean[] isActive;
    private int[][] termLinks;
    protected int[] termPartition;
    protected int numInactiveTerms;
    protected final int numTerms;
    protected int[] positionOfTermInPartition;
    protected boolean[] observedGenes;
    private int[] activeHiddenGenes;

    public MgsaScoreBase(int[][] termLinks, int numItems) {
        this.termLinks = termLinks;
        this.numTerms = termLinks.length;
        this.numInactiveTerms = termLinks.length;
        this.isActive = new boolean[termLinks.length];
        this.termPartition = new int[termLinks.length];
        this.positionOfTermInPartition = new int[termLinks.length];
        this.observedGenes = new boolean[numItems];
        this.activeHiddenGenes = new int[numItems];
        for (int i = 0; i < termLinks.length; ++i) {
            this.termPartition[i] = i;
            this.positionOfTermInPartition[i] = i;
        }
    }

    public void switchState(int toSwitch) {
        int[] geneIDs = this.termLinks[toSwitch];
        boolean bl = this.isActive[toSwitch] = !this.isActive[toSwitch];
        if (this.isActive[toSwitch]) {
            for (int gid : geneIDs) {
                if (this.activeHiddenGenes[gid] == 0) {
                    this.activeHiddenGenes[gid] = 1;
                    this.hiddenGeneActivated(gid);
                    continue;
                }
                int n = gid;
                this.activeHiddenGenes[n] = this.activeHiddenGenes[n] + 1;
            }
            --this.numInactiveTerms;
            if (this.numInactiveTerms != 0) {
                int e0;
                int pos = this.positionOfTermInPartition[toSwitch];
                this.termPartition[pos] = e0 = this.termPartition[this.numInactiveTerms];
                this.positionOfTermInPartition[e0] = pos;
                this.termPartition[this.numInactiveTerms] = toSwitch;
                this.positionOfTermInPartition[toSwitch] = this.numInactiveTerms;
            }
        } else {
            for (int gid : geneIDs) {
                if (this.activeHiddenGenes[gid] == 1) {
                    this.activeHiddenGenes[gid] = 0;
                    this.hiddenGeneDeactivated(gid);
                    continue;
                }
                int n = gid;
                this.activeHiddenGenes[n] = this.activeHiddenGenes[n] - 1;
            }
            if (this.numInactiveTerms != this.isActive.length - 1) {
                int b1;
                int pos = this.positionOfTermInPartition[toSwitch];
                this.termPartition[pos] = b1 = this.termPartition[this.numInactiveTerms];
                this.positionOfTermInPartition[b1] = pos;
                this.termPartition[this.numInactiveTerms] = toSwitch;
                this.positionOfTermInPartition[toSwitch] = this.numInactiveTerms;
            }
            ++this.numInactiveTerms;
        }
    }

    public abstract void hiddenGeneActivated(int var1);

    public abstract void hiddenGeneDeactivated(int var1);
}

