/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.mgsa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.monarchinitiative.phenol.analysis.GoAssociationContainer;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermId;

class TermToItemMatrix {
    private final int n_genes;
    private final int n_annotated_terms;
    private final List<TermId> annotatedItemList;
    private final List<TermId> goTermList;
    private final Map<TermId, Integer> annotatedItemToIndexMap;
    private final Map<TermId, Integer> goTermToIndexMap;
    private final int[][] termLinks;

    TermToItemMatrix(GoAssociationContainer assocs) {
        Objects.requireNonNull(assocs);
        Map<TermId, List<TermId>> termToGeneMultimap = assocs.getOntologyTermToDomainItemsMap();
        Set<TermId> genes = assocs.getAllAnnotatedGenes();
        this.n_genes = genes.size();
        this.n_annotated_terms = termToGeneMultimap.keySet().size();
        int i = 0;
        ArrayList<TermId> builder = new ArrayList<TermId>();
        HashMap<TermId, Integer> mapBuilder = new HashMap<TermId, Integer>();
        for (TermId ontologyTermId : termToGeneMultimap.keySet()) {
            builder.add(ontologyTermId);
            mapBuilder.put(ontologyTermId, i);
            ++i;
        }
        this.goTermList = List.copyOf(builder);
        this.goTermToIndexMap = Map.copyOf(mapBuilder);
        mapBuilder.clear();
        i = 0;
        for (TermId gene : genes) {
            mapBuilder.put(gene, i);
            ++i;
        }
        this.annotatedItemList = List.copyOf(genes);
        this.annotatedItemToIndexMap = Map.copyOf(mapBuilder);
        this.termLinks = new int[this.n_annotated_terms][];
        i = 0;
        for (TermId goTermId : this.goTermList) {
            Collection annotatedsItems = termToGeneMultimap.get(goTermId);
            int goTermIndex = this.goTermToIndexMap.get(goTermId);
            this.termLinks[goTermIndex] = new int[annotatedsItems.size()];
            int j = 0;
            for (TermId geneIdx : annotatedsItems) {
                Integer idx = this.annotatedItemToIndexMap.get(geneIdx);
                if (idx == null || idx < 0) {
                    throw new PhenolRuntimeException("Could not find index of annotated item: " + geneIdx.getValue());
                }
                this.termLinks[goTermIndex][j] = idx;
                ++j;
            }
            ++i;
        }
    }

    public int getNumTerms() {
        return this.n_annotated_terms;
    }

    TermId getGoTermAtIndex(int i) {
        return this.goTermList.get(i);
    }

    public int getAnnotatedGeneCount(TermId goTermId) {
        Integer i = this.goTermToIndexMap.get(goTermId);
        if (i == null || i < 0) {
            System.err.println("[ERROR] Could not find index for GO Term " + String.valueOf(goTermId));
            return 0;
        }
        int[] genes = this.termLinks[i];
        return genes.length;
    }

    public boolean[] getBooleanArrayobservedItems(Set<TermId> geneIds) {
        boolean[] observed = new boolean[this.n_genes];
        for (TermId gene : geneIds) {
            Integer i = this.annotatedItemToIndexMap.get(gene);
            if (i == null || i < 0) {
                System.err.println("[ERROR] Could not get index for gene " + gene.getValue());
                continue;
            }
            observed[i.intValue()] = true;
        }
        return observed;
    }

    public int[][] getTermLinks() {
        return this.termLinks;
    }
}

