/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.scoredist;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.DecoderException;
import org.monarchinitiative.phenol.analysis.scoredist.ObjHexStringConverter;
import org.monarchinitiative.phenol.analysis.scoredist.ScoreDistributionReader;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.scoredist.ObjectScoreDistribution;
import org.monarchinitiative.phenol.ontology.scoredist.ScoreDistribution;

public class H2ScoreDistributionReader
implements ScoreDistributionReader {
    private final String pathDb;
    private final String tableName;
    private final Connection conn;
    private static final String H2_SELECT_TERM_COUNTS = "SELECT DISTINCT num_terms from %s";
    private static final String H2_SELECT_BY_TERM_COUNT_STATEMENT = "SELECT num_terms, object_id, sample_size, scores, p_values FROM %s WHERE num_terms = ?";
    private static final String H2_SELECT_BY_TERM_COUNT_AND_OBJECT_STATEMENT = "SELECT num_terms, object_id, sample_size, scores, p_values FROM %s WHERE num_terms = ? AND object_id = ?";

    public H2ScoreDistributionReader(String pathDb, String tableName) throws PhenolException {
        this.pathDb = pathDb;
        this.tableName = tableName;
        this.conn = this.openConnection();
    }

    private Connection openConnection() throws PhenolException {
        Connection result;
        try {
            Class.forName("org.h2.Driver");
            result = DriverManager.getConnection("jdbc:h2:" + this.pathDb, "", "");
        }
        catch (ClassNotFoundException e) {
            throw new PhenolException("H2 driver class could not be found", (Throwable)e);
        }
        catch (SQLException e) {
            throw new PhenolException("Could not open database at " + this.pathDb, (Throwable)e);
        }
        try (ResultSet rs = result.getMetaData().getTables(null, null, "%", new String[]{"TABLE"});){
            boolean tableExists = rs.next();
            if (!tableExists) {
                throw new PhenolException("Table of name " + this.tableName + " does not exist in database!");
            }
        }
        catch (SQLException e) {
            throw new PhenolException("Checking for table of name " + this.tableName + " failed", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectScoreDistribution readForTermCountAndObject(int termCount, TermId objectId) throws PhenolException {
        try (PreparedStatement stmt = this.conn.prepareStatement(String.format(H2_SELECT_BY_TERM_COUNT_AND_OBJECT_STATEMENT, this.tableName));){
            stmt.setInt(1, termCount);
            try {
                stmt.setString(2, ObjHexStringConverter.object2hex((Serializable)objectId));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert object id to hexadecimal String: " + objectId.toString());
            }
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) throw new PhenolException("Found no object for termCount: " + termCount + ", objectId: " + String.valueOf(objectId));
                ObjectScoreDistribution objectScoreDistribution = this.objectScoreDistributionFromResultSet(rs);
                return objectScoreDistribution;
            }
        }
        catch (SQLException e) {
            throw new PhenolException("Problem with getting object score distribution for termCount: " + termCount + ", objectId: " + String.valueOf(objectId));
        }
    }

    private ObjectScoreDistribution objectScoreDistributionFromResultSet(ResultSet rs) throws SQLException {
        TermId objectId;
        int termCount = rs.getInt(1);
        try {
            objectId = (TermId)ObjHexStringConverter.hex2obj(rs.getString(2));
        }
        catch (IOException | ClassNotFoundException | DecoderException e) {
            throw new SQLException();
        }
        int sampleSize = rs.getInt(3);
        double[] scores = (double[])rs.getObject(4);
        double[] pValues = (double[])rs.getObject(5);
        TreeMap<Double, Double> scoreDist = new TreeMap<Double, Double>();
        for (int i = 0; i < scores.length; ++i) {
            scoreDist.put(scores[i], pValues[i]);
        }
        return new ObjectScoreDistribution(objectId, termCount, sampleSize, scoreDist);
    }

    @Override
    public ScoreDistribution readForTermCount(int termCount) throws PhenolException {
        HashMap<TermId, ObjectScoreDistribution> dists = new HashMap<TermId, ObjectScoreDistribution>();
        try (PreparedStatement stmt = this.conn.prepareStatement(String.format(H2_SELECT_BY_TERM_COUNT_STATEMENT, this.tableName));){
            stmt.setInt(1, termCount);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    ObjectScoreDistribution objScoreDist = this.objectScoreDistributionFromResultSet(rs);
                    dists.put(objScoreDist.getObjectId(), objScoreDist);
                }
            }
        }
        catch (SQLException e) {
            throw new PhenolException("Problem with getting object score distributions for termCount: " + termCount);
        }
        if (dists.size() == 0) {
            throw new PhenolException("Found no score distributions for termCount: " + termCount);
        }
        return new ScoreDistribution(termCount, dists);
    }

    @Override
    public Map<Integer, ScoreDistribution> readAll() throws PhenolException {
        ArrayList<Integer> termCounts = new ArrayList<Integer>();
        try (PreparedStatement stmt = this.conn.prepareStatement(String.format(H2_SELECT_TERM_COUNTS, this.tableName));
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                termCounts.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            throw new PhenolException("Problem querying the database for term counts", (Throwable)e);
        }
        HashMap<Integer, ScoreDistribution> result = new HashMap<Integer, ScoreDistribution>();
        Iterator iterator = termCounts.iterator();
        while (iterator.hasNext()) {
            int termCount = (Integer)iterator.next();
            result.put(termCount, this.readForTermCount(termCount));
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new IOException("Problem closing connection to database", e);
        }
    }
}

