/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.scoredist;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.monarchinitiative.phenol.analysis.scoredist.ObjHexStringConverter;
import org.monarchinitiative.phenol.analysis.scoredist.ScoreDistributionWriter;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.scoredist.ObjectScoreDistribution;
import org.monarchinitiative.phenol.ontology.scoredist.ScoreDistribution;

public class TextFileScoreDistributionWriter
implements ScoreDistributionWriter {
    private final File outputFile;
    private final PrintStream out;

    public TextFileScoreDistributionWriter(File outputFile) throws FileNotFoundException {
        this.outputFile = outputFile;
        this.out = new PrintStream(this.outputFile);
        this.out.println("#numTerms\tentrezId\tsampleSize\tdistribution");
    }

    @Override
    public void write(int numTerms, ScoreDistribution scoreDistribution, int resolution) {
        for (TermId objectId : scoreDistribution.getObjectIds()) {
            ObjectScoreDistribution dist = scoreDistribution.getObjectScoreDistribution(objectId);
            List scores = dist.observedScores();
            ArrayList<CallSite> points = new ArrayList<CallSite>();
            if (resolution != 0) {
                for (int i = 0; i <= resolution; ++i) {
                    double pos = ((double)scores.size() - 1.0) / (double)resolution * (double)i;
                    int left = Math.max(0, (int)Math.floor(pos));
                    int right = Math.min(scores.size() - 1, (int)Math.ceil(pos));
                    double dx = (double)right - pos;
                    double score = (Double)scores.get(left) + (1.0 - dx) * ((Double)scores.get(right) - (Double)scores.get(left));
                    double pValue = dist.estimatePValue(score);
                    points.add((CallSite)((Object)(score + ":" + pValue)));
                }
            } else {
                for (Map.Entry e : dist.getCumulativeFrequencies().entrySet()) {
                    points.add((CallSite)((Object)(String.valueOf(e.getKey()) + ":" + String.valueOf(e.getValue()))));
                }
            }
            this.out.print(numTerms);
            this.out.print("\t");
            try {
                this.out.print(ObjHexStringConverter.object2hex((Serializable)objectId));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write object as hexadecimal string: " + objectId.toString());
            }
            this.out.print("\t");
            this.out.print(dist.getSampleSize());
            this.out.print("\t");
            this.out.println(String.join((CharSequence)",", points));
        }
    }

    @Override
    public void close() {
        this.out.close();
    }
}

