/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.stats;

import org.monarchinitiative.phenol.analysis.stats.PValue;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class GoTerm2PValAndCounts
extends PValue {
    private final int annotatedStudyGenes;
    private final int annotatedPopulationGenes;
    private final int totalStudyGenes;
    private final int totalPopulationGenes;

    public GoTerm2PValAndCounts(TermId goId, double raw_pval, int annotatedStudyGenes, int totalStudyGenes, int annotatedPopulationGenes, int totalPopulationGenes) {
        super(goId, raw_pval);
        this.annotatedStudyGenes = annotatedStudyGenes;
        this.totalStudyGenes = totalStudyGenes;
        this.annotatedPopulationGenes = annotatedPopulationGenes;
        this.totalPopulationGenes = totalPopulationGenes;
    }

    public int getAnnotatedStudyGenes() {
        return this.annotatedStudyGenes;
    }

    public int getTotalStudyGenes() {
        return this.totalStudyGenes;
    }

    public int getAnnotatedPopulationGenes() {
        return this.annotatedPopulationGenes;
    }

    public int getTotalPopulationGenes() {
        return this.totalPopulationGenes;
    }

    public TermId getGoTermId() {
        return this.getItem();
    }

    public String[] getRowData(MinimalOntology ontology) {
        String label = ontology.termForTermId(this.item).map(Term::getName).orElse(null);
        String study = String.format("%d/%d(%.1f%%)", this.annotatedStudyGenes, this.totalStudyGenes, 100.0 * (double)this.annotatedStudyGenes / (double)this.totalStudyGenes);
        String population = String.format("%d/%d(%.1f%%)", this.annotatedPopulationGenes, this.totalPopulationGenes, 100.0 * (double)this.annotatedPopulationGenes / (double)this.totalPopulationGenes);
        return new String[]{label, this.item.getValue(), study, population, String.format("%.2e", this.p_raw), String.format("%.2e", this.p_adjusted)};
    }

    public boolean passesThreshold(double alphaThreshold) {
        return this.p_adjusted <= alphaThreshold;
    }

    public String getRow(Ontology ontology) {
        return String.join((CharSequence)"\t", this.getRowData((MinimalOntology)ontology));
    }

    public static String header() {
        CharSequence[] fields = new String[]{"id", "study", "population", "p.val", "adj.p.val"};
        return String.join((CharSequence)"\t", fields);
    }

    public String toString() {
        return String.format("%s: study: %d; population: %d; p.val: %e; adj.p.val: %e", this.item.getValue(), this.annotatedStudyGenes, this.annotatedPopulationGenes, this.p_raw, this.p_adjusted);
    }
}

