/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.stats;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.monarchinitiative.phenol.analysis.DirectAndIndirectTermAnnotations;
import org.monarchinitiative.phenol.analysis.StudySet;
import org.monarchinitiative.phenol.analysis.stats.GoTerm2PValAndCounts;
import org.monarchinitiative.phenol.analysis.stats.PValueCalculation;
import org.monarchinitiative.phenol.analysis.stats.mtc.MultipleTestingCorrection;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParentChildPValuesCalculation
extends PValueCalculation {
    Logger LOGGER = LoggerFactory.getLogger(ParentChildPValuesCalculation.class);
    private final TermId OWL_THING = TermId.of((String)"owl:Thing");
    protected final Map<TermId, DirectAndIndirectTermAnnotations> studySetAnnotationMap = this.studySet.getAnnotationMap();

    public ParentChildPValuesCalculation(Ontology graph, StudySet populationSet, StudySet studySet, MultipleTestingCorrection mtc) {
        super((MinimalOntology)graph, populationSet, studySet, mtc);
    }

    @Override
    public List<GoTerm2PValAndCounts> calculatePVals() {
        Map<TermId, DirectAndIndirectTermAnnotations> populationSetAnnotationMap = this.populationSet.getAnnotationMap();
        ArrayList<GoTerm2PValAndCounts> results = new ArrayList<GoTerm2PValAndCounts>();
        for (Map.Entry<TermId, DirectAndIndirectTermAnnotations> entry : this.studySetAnnotationMap.entrySet()) {
            TermId goId;
            if (entry.getValue().totalAnnotatedCount() < 2 || (goId = entry.getKey()).equals((Object)this.OWL_THING)) continue;
            if (!this.populationSet.getAnnotationMap().containsKey(goId)) {
                this.LOGGER.error("Study set contains GO ID ({}) but pop set does not: ", (Object)goId.getValue());
                continue;
            }
            int goidAnnotatedPopGeneCount = populationSetAnnotationMap.get(goId).totalAnnotatedCount();
            int goidAnnotatedStudyGeneCount = this.studySetAnnotationMap.get(goId).totalAnnotatedCount();
            if (goidAnnotatedStudyGeneCount == 0) continue;
            Counts count = this.getCounts(goId, this.ontology.graph().getParents((Object)goId, false));
            int m_pa_t = count.m_pa_t;
            int n_pa_t = count.n_pa_t;
            int m_t = count.m_t;
            double raw_pval = m_t == m_pa_t ? 1.0 : this.hyperg.phypergeometric(m_pa_t, m_t, n_pa_t, count.n_t);
            GoTerm2PValAndCounts goPval = new GoTerm2PValAndCounts(goId, raw_pval, goidAnnotatedStudyGeneCount, this.studySet.getAnnotatedItemCount(), goidAnnotatedPopGeneCount, this.populationSet.getAnnotatedItemCount());
            results.add(goPval);
        }
        this.testCorrection.adjustPvals(results);
        return results;
    }

    protected abstract Counts getCounts(TermId var1, Iterable<TermId> var2);

    protected static class Counts {
        public final int n_pa_t;
        public final int m_pa_t;
        public final int m_t;
        public final int n_t;

        public Counts(int n_pa_t, int m_pa_t, int n_t, int m_t) {
            this.n_pa_t = n_pa_t;
            this.m_pa_t = m_pa_t;
            this.n_t = n_t;
            this.m_t = m_t;
        }

        public double get_proportion() {
            return (double)this.m_t / (double)this.m_pa_t;
        }
    }
}

