/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.stats;

import java.util.HashSet;
import java.util.Set;
import org.monarchinitiative.phenol.analysis.StudySet;
import org.monarchinitiative.phenol.analysis.stats.ParentChildPValuesCalculation;
import org.monarchinitiative.phenol.analysis.stats.mtc.MultipleTestingCorrection;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.utils.Sets;

public class ParentChildUnionPValueCalculation
extends ParentChildPValuesCalculation {
    public ParentChildUnionPValueCalculation(Ontology graph, StudySet populationSet, StudySet studySet, MultipleTestingCorrection mtc) {
        super(graph, populationSet, studySet, mtc);
    }

    @Override
    protected ParentChildPValuesCalculation.Counts getCounts(TermId goId, Iterable<TermId> parents) {
        HashSet<TermId> parentsUnion = new HashSet<TermId>();
        Set<TermId> genesAnnotatedToGoId = this.populationSet.getAnnotationMap().get(goId).getTotalAnnotatedDomainItemSet();
        int m_t = genesAnnotatedToGoId.size();
        Set<TermId> studs = this.studySet.getGeneSet();
        int n_t = Sets.intersection(studs, genesAnnotatedToGoId).size();
        for (TermId par : parents) {
            Set<TermId> annotedGeneIds = this.populationSet.getAnnotationMap().get(par).getTotalAnnotatedDomainItemSet();
            parentsUnion.addAll(annotedGeneIds);
        }
        int m_pa_t = parentsUnion.size();
        int n_pa_t = Sets.intersection(studs, parentsUnion).size();
        return new ParentChildPValuesCalculation.Counts(n_pa_t, m_pa_t, n_t, m_t);
    }
}

