/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.stats;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.monarchinitiative.phenol.analysis.DirectAndIndirectTermAnnotations;
import org.monarchinitiative.phenol.analysis.StudySet;
import org.monarchinitiative.phenol.analysis.stats.GoTerm2PValAndCounts;
import org.monarchinitiative.phenol.analysis.stats.PValueCalculation;
import org.monarchinitiative.phenol.analysis.stats.mtc.MultipleTestingCorrection;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermForTermPValueCalculation
extends PValueCalculation {
    Logger LOGGER = LoggerFactory.getLogger(TermForTermPValueCalculation.class);

    public TermForTermPValueCalculation(MinimalOntology graph, StudySet populationSet, StudySet studySet, MultipleTestingCorrection mtc) {
        super(graph, populationSet, studySet, mtc);
    }

    @Override
    public List<GoTerm2PValAndCounts> calculatePVals() {
        Map<TermId, DirectAndIndirectTermAnnotations> studySetAnnotationMap = this.studySet.getAnnotationMap();
        Map<TermId, DirectAndIndirectTermAnnotations> populationSetAnnotationMap = this.populationSet.getAnnotationMap();
        ArrayList<GoTerm2PValAndCounts> results = new ArrayList<GoTerm2PValAndCounts>();
        int popGeneCount = this.populationSet.getAnnotatedItemCount();
        int studyGeneCount = this.studySet.getAnnotatedItemCount();
        for (Map.Entry<TermId, DirectAndIndirectTermAnnotations> entry : studySetAnnotationMap.entrySet()) {
            if (entry.getValue().totalAnnotatedCount() < 2) continue;
            TermId goId = entry.getKey();
            if (!this.populationSet.getAnnotationMap().containsKey(goId)) {
                this.LOGGER.error("Study set contains GO ID ({}) but pop set does not: ", (Object)goId.getValue());
            }
            int goidAnnotatedPopGeneCount = this.populationSet.getTotalAnnotationCount(goId);
            int goidAnnotatedStudyGeneCount = this.studySet.getTotalAnnotationCount(goId);
            if (goidAnnotatedStudyGeneCount == 0) continue;
            double raw_pval = this.hyperg.phypergeometric(popGeneCount, (double)goidAnnotatedPopGeneCount / (double)popGeneCount, studyGeneCount, goidAnnotatedStudyGeneCount);
            GoTerm2PValAndCounts goPval = new GoTerm2PValAndCounts(goId, raw_pval, goidAnnotatedStudyGeneCount, studyGeneCount, goidAnnotatedPopGeneCount, popGeneCount);
            results.add(goPval);
        }
        this.testCorrection.adjustPvals(results);
        return results;
    }
}

