/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.stats.mtc;

import java.util.Collections;
import java.util.List;
import org.monarchinitiative.phenol.analysis.stats.PValue;
import org.monarchinitiative.phenol.analysis.stats.mtc.MultipleTestingCorrection;

public class BenjaminiYekutieli
implements MultipleTestingCorrection {
    @Override
    public void adjustPvals(List<? extends PValue> pvals) {
        Collections.sort(pvals);
        int N = pvals.size();
        double h = 0.0;
        for (int l = 1; l <= N; ++l) {
            h += 1.0 / (double)l;
        }
        for (int r = 0; r < N; ++r) {
            PValue item = pvals.get(r);
            double raw_p = item.getRawPValue();
            double adj_p = raw_p * (double)N * h / (double)(r + 1);
            item.setAdjustedPValue(adj_p);
        }
        this.enforcePValueMonotony(pvals);
    }

    @Override
    public String getName() {
        return "Benjamini-Yekutieli";
    }
}

