/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.analysis.stats.mtc;

import java.util.Collections;
import java.util.List;
import org.monarchinitiative.phenol.analysis.stats.PValue;
import org.monarchinitiative.phenol.analysis.stats.mtc.MultipleTestingCorrection;

public class BonferroniHolm
implements MultipleTestingCorrection {
    private static final String NAME = "Bonferroni-Holm";

    @Override
    public void adjustPvals(List<? extends PValue> pvals) {
        Collections.sort(pvals);
        int N = pvals.size();
        for (int r = 0; r < N; ++r) {
            PValue item = pvals.get(r);
            double raw_p = item.getRawPValue();
            item.setAdjustedPValue(raw_p * (double)N / (double)(r + 1));
        }
        this.enforcePValueMonotony(pvals);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

