/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import org.monarchinitiative.phenol.annotations.assoc.GeneInfoParser;
import org.monarchinitiative.phenol.annotations.formats.Gene;
import org.monarchinitiative.phenol.annotations.formats.hpo.AssociationType;
import org.monarchinitiative.phenol.annotations.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class Mim2GeneMedgenParser {
    private static final String ENTREZ_GENE_PREFIX = "NCBIGene";
    private static final String OMIM_PREFIX = "OMIM";

    public static Multimap<TermId, GeneToAssociation> loadDiseaseToGeneAssociationMapOMIM(String homoSapiensGeneInfoPath, String mim2geneMedgenPath) {
        Map<TermId, String> geneIdToSymbolMap = GeneInfoParser.loadGeneIdToSymbolMap(homoSapiensGeneInfoPath);
        return Mim2GeneMedgenParser.loadDiseaseToGeneAssociationMapOMIM(geneIdToSymbolMap, mim2geneMedgenPath);
    }

    public static Multimap<TermId, GeneToAssociation> loadDiseaseToGeneAssociationMapOMIM(Map<TermId, String> geneIdToSymbolMap, String mim2geneMedgene) {
        File mim2geneMedgenFile = new File(mim2geneMedgene);
        if (!mim2geneMedgenFile.exists()) {
            throw new PhenolRuntimeException("Could not find mim2gene_medgen file at " + mim2geneMedgene);
        }
        ArrayListMultimap associationMap = ArrayListMultimap.create();
        try (BufferedReader br = new BufferedReader(new FileReader(mim2geneMedgenFile));){
            String line;
            while ((line = br.readLine()) != null) {
                GeneToAssociation g2a;
                String[] associations;
                if (line.startsWith("#") || !(associations = line.split("\t"))[2].equals("phenotype")) continue;
                String mimid = associations[0];
                TermId omimCurie = TermId.of((String)OMIM_PREFIX, (String)mimid);
                String entrezGeneNumber = associations[1];
                TermId entrezId = TermId.of((String)ENTREZ_GENE_PREFIX, (String)entrezGeneNumber);
                String symbol = geneIdToSymbolMap.get(entrezId);
                if ("-".equals(entrezGeneNumber)) continue;
                if (symbol == null) {
                    symbol = "-";
                }
                TermId geneId = TermId.of((String)ENTREZ_GENE_PREFIX, (String)entrezGeneNumber);
                Gene gene = new Gene(geneId, symbol);
                AssociationType associationType = AssociationType.MENDELIAN;
                if (associations[5].contains("susceptibility")) {
                    associationType = AssociationType.POLYGENIC;
                }
                if (associationMap.containsEntry((Object)omimCurie, (Object)(g2a = new GeneToAssociation(gene, associationType)))) continue;
                associationMap.put((Object)omimCurie, (Object)g2a);
            }
        }
        catch (IOException e) {
            String msg = String.format("Could not create gene association map: %s", e.getMessage());
            throw new PhenolRuntimeException(msg);
        }
        return associationMap;
    }
}

