/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.monarchinitiative.phenol.annotations.formats.EvidenceCode;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoOnset;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoAnnotation
implements Comparable<HpoAnnotation> {
    private static final String DEFAULT_FREQUENCY_STRING = "n/a";
    private final TermId termId;
    private final double frequency;
    private final String frequencyString;
    private final HpoOnset onset;
    private final List<TermId> modifiers;
    private final List<String> citations;
    private final EvidenceCode evidence;

    public HpoAnnotation(TermId termId, double f, String freqString, HpoOnset onset, List<TermId> modifiers, List<String> cites, EvidenceCode ec) {
        this.termId = termId;
        this.frequency = f;
        this.frequencyString = freqString.isEmpty() ? DEFAULT_FREQUENCY_STRING : freqString;
        this.onset = onset;
        this.modifiers = modifiers;
        this.citations = cites;
        this.evidence = ec;
    }

    public static HpoAnnotation forTerm(TermId t) {
        return new Builder(t).build();
    }

    public static HpoAnnotation parseTerm(String id) {
        TermId tid = TermId.of((String)id);
        return HpoAnnotation.forTerm(tid);
    }

    public String getFrequencyString() {
        return this.frequencyString;
    }

    public List<String> getCitations() {
        return this.citations;
    }

    public TermId getTermId() {
        return this.termId;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public HpoOnset getOnset() {
        return this.onset;
    }

    public List<TermId> getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        return "HpoTermId [termId=" + this.termId + ", frequency=" + this.frequency + ", onset=" + (Object)((Object)this.onset) + "]";
    }

    public String getIdWithPrefix() {
        return this.termId.getValue();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (!(that instanceof HpoAnnotation)) {
            return false;
        }
        HpoAnnotation otherHpoAnnotation = (HpoAnnotation)that;
        return this.termId.equals((Object)otherHpoAnnotation.getTermId()) && this.frequency == otherHpoAnnotation.getFrequency() && this.onset.equals((Object)otherHpoAnnotation.getOnset()) && this.modifiers.equals(otherHpoAnnotation.modifiers);
    }

    public boolean isPCS() {
        return this.evidence == EvidenceCode.PCS;
    }

    public boolean isIEA() {
        return this.evidence == EvidenceCode.IEA;
    }

    public boolean isTAS() {
        return this.evidence == EvidenceCode.TAS;
    }

    public String getEvidenceCodeString() {
        return this.evidence.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.termId.hashCode();
        result = 31 * result + Double.valueOf(this.frequency).hashCode();
        result = 31 * result + this.onset.hashCode();
        result = 31 * result + this.modifiers.hashCode();
        return result;
    }

    @Override
    public int compareTo(HpoAnnotation that) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == that) {
            return 0;
        }
        if (!this.termId.equals((Object)that.termId)) {
            return this.termId.compareTo(that.termId);
        }
        if (this.frequency < that.frequency) {
            return -1;
        }
        if (that.frequency < this.frequency) {
            return 1;
        }
        if (!this.onset.equals((Object)that.onset)) {
            return this.onset.compareTo(that.onset);
        }
        return 0;
    }

    public static Builder builder(TermId termId) {
        return new Builder(termId);
    }

    public static class Builder {
        private static final HpoFrequency DEFAULT_HPO_FREQUENCY = HpoFrequency.ALWAYS_PRESENT;
        private static final HpoOnset DEFAULT_HPO_ONSET = HpoOnset.ONSET;
        private static final EvidenceCode DEFAULT_EVIDENCE_CODE = EvidenceCode.IEA;
        private final TermId termId;
        private String frequencyString = "n/a";
        private List<String> citations = null;
        private double frequency = DEFAULT_HPO_FREQUENCY.mean();
        private HpoOnset onset = DEFAULT_HPO_ONSET;
        private EvidenceCode evidence = DEFAULT_EVIDENCE_CODE;
        private List<TermId> modifierList = ImmutableList.of();

        public Builder(TermId tid) {
            Objects.requireNonNull(tid, "TermId cannot be null");
            this.termId = tid;
        }

        public Builder onset(HpoOnset o) {
            if (o != null) {
                this.onset = o;
            }
            return this;
        }

        public Builder frequency(double f, String freqString) {
            this.checkBoundsWithinZeroToOne(f);
            this.frequency = f;
            this.frequencyString = freqString;
            return this;
        }

        private void checkBoundsWithinZeroToOne(double f) {
            try {
                assert (f >= 0.0 && f <= 1.0);
            }
            catch (AssertionError ex) {
                throw new IllegalArgumentException(f + " Frequency must be within range 0-1");
            }
        }

        public Builder modifiers(Collection<TermId> modifiers) {
            Objects.requireNonNull(modifiers, "modifiers cannot be null");
            this.modifierList = ImmutableList.copyOf(modifiers);
            return this;
        }

        public Builder citations(List<String> cites) {
            this.citations = cites;
            return this;
        }

        public Builder evidence(String evid) {
            this.evidence = EvidenceCode.fromString(evid);
            return this;
        }

        public HpoAnnotation build() {
            if (this.citations == null) {
                this.citations = ImmutableList.of();
            }
            return new HpoAnnotation(this.termId, this.frequency, this.frequencyString, this.onset, this.modifierList, this.citations, this.evidence);
        }
    }
}

