/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import org.monarchinitiative.phenol.annotations.formats.hpo.HpoOnsetTermIds;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermId;

public enum HpoOnset {
    ONSET,
    ANTENATAL_ONSET,
    EMBRYONAL_ONSET,
    FETAL_ONSET,
    CONGENITAL_ONSET,
    NEONATAL_ONSET,
    INFANTILE_ONSET,
    CHILDHOOD_ONSET,
    JUVENILE_ONSET,
    ADULT_ONSET,
    YOUNG_ADULT_ONSET,
    MIDDLE_AGE_ONSET,
    LATE_ONSET,
    UNKNOWN;

    static final double ADULT_ONSET_UPPERBOUND = 100.0;

    public double lowerBound() {
        switch (this) {
            case ANTENATAL_ONSET: {
                return 0.0;
            }
            case CONGENITAL_ONSET: {
                return 0.0;
            }
            case NEONATAL_ONSET: {
                return 0.0;
            }
            case INFANTILE_ONSET: {
                return 0.0;
            }
            case CHILDHOOD_ONSET: {
                return 1.0;
            }
            case JUVENILE_ONSET: {
                return 5.0;
            }
            case ADULT_ONSET: {
                return 100.0;
            }
            case YOUNG_ADULT_ONSET: {
                return 40.0;
            }
            case MIDDLE_AGE_ONSET: {
                return 60.0;
            }
            case LATE_ONSET: {
                return 100.0;
            }
        }
        return 100.0;
    }

    public double upperBound() {
        switch (this) {
            case ANTENATAL_ONSET: {
                return 0.0;
            }
            case CONGENITAL_ONSET: {
                return 0.0;
            }
            case NEONATAL_ONSET: {
                return 0.07671232876712329;
            }
            case INFANTILE_ONSET: {
                return 1.0;
            }
            case CHILDHOOD_ONSET: {
                return 5.0;
            }
            case JUVENILE_ONSET: {
                return 15.0;
            }
            case ADULT_ONSET: {
                return 16.0;
            }
            case YOUNG_ADULT_ONSET: {
                return 16.0;
            }
            case MIDDLE_AGE_ONSET: {
                return 40.0;
            }
            case LATE_ONSET: {
                return 60.0;
            }
        }
        return 0.0;
    }

    public boolean available() {
        return this != UNKNOWN && this != ONSET;
    }

    public TermId toTermId() {
        switch (this) {
            case ANTENATAL_ONSET: {
                return HpoOnsetTermIds.ANTENATAL_ONSET;
            }
            case CONGENITAL_ONSET: {
                return HpoOnsetTermIds.CONGENITAL_ONSET;
            }
            case NEONATAL_ONSET: {
                return HpoOnsetTermIds.NEONATAL_ONSET;
            }
            case INFANTILE_ONSET: {
                return HpoOnsetTermIds.INFANTILE_ONSET;
            }
            case CHILDHOOD_ONSET: {
                return HpoOnsetTermIds.CHILDHOOD_ONSET;
            }
            case JUVENILE_ONSET: {
                return HpoOnsetTermIds.JUVENILE_ONSET;
            }
            case ADULT_ONSET: {
                return HpoOnsetTermIds.ADULT_ONSET;
            }
            case YOUNG_ADULT_ONSET: {
                return HpoOnsetTermIds.YOUNG_ADULT_ONSET;
            }
            case MIDDLE_AGE_ONSET: {
                return HpoOnsetTermIds.MIDDLE_AGE_ONSET;
            }
            case LATE_ONSET: {
                return HpoOnsetTermIds.LATE_ONSET;
            }
        }
        return HpoOnsetTermIds.ONSET_TERMID;
    }

    public static HpoOnset fromTermId(TermId termId) {
        switch (termId.getValue()) {
            case "HP:0003674": {
                return ONSET;
            }
            case "HP:0003577": {
                return CONGENITAL_ONSET;
            }
            case "HP:0003581": {
                return ADULT_ONSET;
            }
            case "HP:0003584": {
                return LATE_ONSET;
            }
            case "HP:0011462": {
                return YOUNG_ADULT_ONSET;
            }
            case "HP:0003596": {
                return MIDDLE_AGE_ONSET;
            }
            case "HP:0003593": {
                return INFANTILE_ONSET;
            }
            case "HP:0030674": {
                return ANTENATAL_ONSET;
            }
            case "HP:0011460": {
                return EMBRYONAL_ONSET;
            }
            case "HP:0011461": {
                return FETAL_ONSET;
            }
            case "HP:0003621": {
                return JUVENILE_ONSET;
            }
            case "HP:0003623": {
                return NEONATAL_ONSET;
            }
            case "HP:0011463": {
                return CHILDHOOD_ONSET;
            }
        }
        return UNKNOWN;
    }

    public static HpoOnset fromHpoIdString(String termId) {
        switch (termId) {
            case "HP:0003674": {
                return ONSET;
            }
            case "HP:0003577": {
                return CONGENITAL_ONSET;
            }
            case "HP:0003581": {
                return ADULT_ONSET;
            }
            case "HP:0003584": {
                return LATE_ONSET;
            }
            case "HP:0011462": {
                return YOUNG_ADULT_ONSET;
            }
            case "HP:0003596": {
                return MIDDLE_AGE_ONSET;
            }
            case "HP:0003593": {
                return INFANTILE_ONSET;
            }
            case "HP:0030674": {
                return ANTENATAL_ONSET;
            }
            case "HP:0011460": {
                return EMBRYONAL_ONSET;
            }
            case "HP:0011461": {
                return FETAL_ONSET;
            }
            case "HP:0003621": {
                return JUVENILE_ONSET;
            }
            case "HP:0003623": {
                return NEONATAL_ONSET;
            }
            case "HP:0011463": {
                return CHILDHOOD_ONSET;
            }
        }
        throw new PhenolRuntimeException("TermId " + termId + " is not a valid onset sub ontology term ID");
    }

    public static HpoOnset fromAge(int years, int months, int days) {
        if (years >= 1 && years < 5) {
            return CHILDHOOD_ONSET;
        }
        if (years >= 5 && years <= 15) {
            return JUVENILE_ONSET;
        }
        if (years >= 16 && years < 40) {
            return YOUNG_ADULT_ONSET;
        }
        if (years >= 40 && years < 60) {
            return MIDDLE_AGE_ONSET;
        }
        if (years >= 60) {
            return LATE_ONSET;
        }
        if (years < 1 && months > 1) {
            return INFANTILE_ONSET;
        }
        if (years < 1 && months <= 1) {
            return NEONATAL_ONSET;
        }
        if (years < 1 && months < 1 && days <= 1) {
            return CONGENITAL_ONSET;
        }
        return ONSET;
    }
}

