/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.monarchinitiative.phenol.annotations.assoc.Mim2GeneMedgenLoader;
import org.monarchinitiative.phenol.annotations.assoc.OrphaGeneToDiseaseParser;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifiers;
import org.monarchinitiative.phenol.annotations.formats.hpo.AssociationType;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociation;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociations;
import org.monarchinitiative.phenol.annotations.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class DiseaseToGeneAssociationLoader {
    private DiseaseToGeneAssociationLoader() {
    }

    public static DiseaseToGeneAssociations loadDiseaseToGeneAssociations(Path mim2geneMedgen, GeneIdentifiers geneIdentifiers) throws IOException {
        return DiseaseToGeneAssociationLoader.loadDiseaseToGeneAssociations(mim2geneMedgen, null, geneIdentifiers);
    }

    public static DiseaseToGeneAssociations loadDiseaseToGeneAssociations(Path mim2geneMedgen, Path orphanet2Gene, GeneIdentifiers geneIdentifiers) throws IOException {
        DiseaseToGeneAssociations omimDiseaseToGeneAssociations = Mim2GeneMedgenLoader.loadDiseaseToGeneAssociations(mim2geneMedgen, geneIdentifiers.geneIdToSymbol());
        if (orphanet2Gene == null) {
            return omimDiseaseToGeneAssociations;
        }
        Map<String, Collection<TermId>> diseaseMimToGeneIds = DiseaseToGeneAssociationLoader.prepareDiseaseMimToGeneIds(omimDiseaseToGeneAssociations);
        Map<TermId, Collection<GeneIdentifier>> orphaDiseaseToGeneIds = OrphaGeneToDiseaseParser.parseOrphaGeneXml(orphanet2Gene, diseaseMimToGeneIds, geneIdentifiers.symbolToGeneIdentifier());
        DiseaseToGeneAssociations orphaDiseaseToGeneAssociations = DiseaseToGeneAssociationLoader.postprocessOrphaMappings(orphaDiseaseToGeneIds);
        List<DiseaseToGeneAssociation> associations = Stream.concat(omimDiseaseToGeneAssociations.diseaseToGeneAssociations(), orphaDiseaseToGeneAssociations.diseaseToGeneAssociations()).collect(Collectors.toUnmodifiableList());
        return DiseaseToGeneAssociations.of(associations);
    }

    private static Map<String, Collection<TermId>> prepareDiseaseMimToGeneIds(DiseaseToGeneAssociations mimDiseaseToGeneAssociations) {
        HashMap<String, Collection<TermId>> diseaseMimToGeneIds = new HashMap<String, Collection<TermId>>();
        for (DiseaseToGeneAssociation association : mimDiseaseToGeneAssociations) {
            String diseaseMim = association.diseaseId().getId();
            List geneIds = association.associations().stream().map(ga -> ga.geneIdentifier().id()).collect(Collectors.toUnmodifiableList());
            diseaseMimToGeneIds.put(diseaseMim, geneIds);
        }
        return diseaseMimToGeneIds;
    }

    private static DiseaseToGeneAssociations postprocessOrphaMappings(Map<TermId, Collection<GeneIdentifier>> orphaDiseaseToGeneIds) {
        ArrayList<DiseaseToGeneAssociation> orphaAssociations = new ArrayList<DiseaseToGeneAssociation>(orphaDiseaseToGeneIds.size());
        for (Map.Entry<TermId, Collection<GeneIdentifier>> entry : orphaDiseaseToGeneIds.entrySet()) {
            TermId orphaDiseaseId = entry.getKey();
            List<GeneToAssociation> geneAssociations = entry.getValue().stream().map(gi -> GeneToAssociation.of(gi, AssociationType.UNKNOWN)).collect(Collectors.toUnmodifiableList());
            orphaAssociations.add(DiseaseToGeneAssociation.of(orphaDiseaseId, geneAssociations));
        }
        return DiseaseToGeneAssociations.of(Collections.unmodifiableList(orphaAssociations));
    }
}

