/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.monarchinitiative.phenol.annotations.assoc.DiseaseToGeneAssociationLoader;
import org.monarchinitiative.phenol.annotations.assoc.HumanGeneInfoLoader;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifiers;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociations;
import org.monarchinitiative.phenol.annotations.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAssociationData;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseases;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotation;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoader;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpoAssociationLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HpoAssociationLoader.class);

    private HpoAssociationLoader() {
    }

    public static HpoAssociationData loadHpoAssociationData(Ontology hpo, Path homoSapiensGeneInfo, Path mim2geneMedgen, Path orphaToGene, Path phenotypeHpoa, HpoDiseaseLoaderOptions options) throws IOException {
        HpoDiseaseLoader loader = HpoDiseaseLoader.of(hpo, options);
        HpoDiseases diseases = loader.load(phenotypeHpoa);
        return HpoAssociationLoader.loadHpoAssociationData(hpo, homoSapiensGeneInfo, mim2geneMedgen, orphaToGene, diseases);
    }

    public static HpoAssociationData loadHpoAssociationData(Ontology hpo, Path homoSapiensGeneInfo, Path mim2geneMedgen, Path orphaToGene, HpoDiseases diseases) throws IOException {
        GeneIdentifiers geneIdentifiers = HumanGeneInfoLoader.loadGeneIdentifiers(homoSapiensGeneInfo);
        Map<TermId, String> geneIdToSymbol = geneIdentifiers.geneIdToSymbol();
        DiseaseToGeneAssociations diseaseToGeneAssociations = DiseaseToGeneAssociationLoader.loadDiseaseToGeneAssociations(mim2geneMedgen, orphaToGene, geneIdentifiers);
        Map<TermId, Collection<GeneToAssociation>> diseaseToGeneMap = diseaseToGeneAssociations.diseaseIdToGeneAssociations();
        Map<TermId, Collection<GeneIdentifier>> diseaseToGenes = diseaseToGeneAssociations.diseaseIdToGeneIds();
        Map<TermId, Collection<TermId>> geneToDiseases = diseaseToGeneAssociations.geneIdToDiseaseIds();
        List<HpoGeneAnnotation> hpoGeneAnnotations = HpoAssociationLoader.processDiseaseMapToHpoGeneAnnotations(hpo.getTermMap(), diseaseToGeneMap, geneIdToSymbol, diseases);
        return HpoAssociationData.of(geneIdentifiers.geneIdentifiers(), diseaseToGenes, geneToDiseases, hpoGeneAnnotations, diseaseToGeneAssociations);
    }

    private static List<HpoGeneAnnotation> processDiseaseMapToHpoGeneAnnotations(Map<TermId, Term> termIdToTerm, Map<TermId, Collection<GeneToAssociation>> diseaseToGeneMap, Map<TermId, String> geneIdToSymbolMap, HpoDiseases diseases) {
        HashMap<TermId, Collection> phenotypeToDisease = new HashMap<TermId, Collection>();
        for (HpoDisease disease2 : diseases) {
            Iterator<HpoDiseaseAnnotation> iterator = disease2.phenotypicAbnormalities();
            while (iterator.hasNext()) {
                TermId hpoId = iterator.next().id();
                phenotypeToDisease.computeIfAbsent(hpoId, k -> new HashSet()).add(disease2.id());
            }
        }
        ArrayList geneAnnotationListBuilder = new ArrayList();
        HashSet mappedGenesTracker = new HashSet();
        for (TermId phenotype : phenotypeToDisease.keySet()) {
            Term phenotypeTerm = termIdToTerm.get(phenotype);
            if (phenotypeTerm != null) {
                ((Collection)phenotypeToDisease.get(phenotype)).stream().flatMap(disease -> ((Collection)diseaseToGeneMap.getOrDefault(disease, List.of())).stream()).map(GeneToAssociation::geneIdentifier).forEach(gene -> {
                    try {
                        int entrezId = Integer.parseInt(gene.id().getId());
                        if (!mappedGenesTracker.contains(gene.id())) {
                            String entrezGeneSymbol = geneIdToSymbolMap.getOrDefault(gene.id(), "-");
                            HpoGeneAnnotation geneAnnotation = new HpoGeneAnnotation(entrezId, entrezGeneSymbol, phenotype, phenotypeTerm.getName());
                            geneAnnotationListBuilder.add(geneAnnotation);
                            mappedGenesTracker.add(gene.id());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("An exception found during creating HPO-gene annotations: " + e.getMessage() + " for gene: " + gene.toString());
                    }
                });
            }
            mappedGenesTracker.clear();
        }
        return List.copyOf(geneAnnotationListBuilder);
    }
}

