/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.assoc.FileUtils;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifiers;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HumanGeneInfoLoader {
    private static final String ENTREZ_GENE_PREFIX = "NCBIGene";

    private HumanGeneInfoLoader() {
    }

    public static GeneIdentifiers loadGeneIdentifiers(Path geneInfoFile) throws IOException {
        try (BufferedReader reader = FileUtils.newBufferedReader(geneInfoFile);){
            List<GeneIdentifier> identifiers = reader.lines().map(HumanGeneInfoLoader.toGeneIdentifier()).flatMap(Optional::stream).distinct().collect(Collectors.toUnmodifiableList());
            GeneIdentifiers geneIdentifiers = GeneIdentifiers.of(identifiers);
            return geneIdentifiers;
        }
    }

    private static Function<String, Optional<GeneIdentifier>> toGeneIdentifier() {
        return line -> {
            String[] a = line.split("\t");
            String taxon = a[0];
            if (!taxon.equals("9606")) {
                return Optional.empty();
            }
            if ("unknown".equals(a[9])) {
                return Optional.empty();
            }
            TermId tid = TermId.of((String)ENTREZ_GENE_PREFIX, (String)a[1]);
            return Optional.of(GeneIdentifier.of(tid, a[2]));
        };
    }
}

