/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.XMLEvent;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrphaGeneToDiseaseParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrphaGeneToDiseaseParser.class);
    private static final String DISORDER = "Disorder";
    private static final String ORPHA_NUMBER = "OrphaCode";
    private static final String GENE_LIST = "GeneList";
    private static final String GENE = "Gene";
    private static final String NAME = "Name";
    private static final String DISORDER_GENE_ASSOCIATION_LIST = "DisorderGeneAssociationList";
    private static final String DISORDER_GENE_ASSOCIATION = "DisorderGeneAssociation";
    private static final String SYMBOL = "Symbol";
    private static final String EXTERNAL_REFERENCE = "ExternalReference";
    private static final String REFERENCE = "Reference";
    private static final String SOURCE = "Source";

    public static Map<TermId, Collection<GeneIdentifier>> parseOrphaGeneXml(Path orphaGeneXMLfile, Map<String, Collection<TermId>> mimIdToGeneIdMap, Map<String, GeneIdentifier> symbolToGeneId) {
        Map<TermId, Collection<GeneIdentifier>> map;
        block31: {
            boolean inDisorder = false;
            boolean inGeneList = false;
            boolean inGene = true;
            boolean inDisorderGeneAssociation = false;
            boolean inDisorderGeneAssociationList = false;
            boolean inExternalReference = false;
            boolean inOMIMReference = false;
            InputStream in = Files.newInputStream(orphaGeneXMLfile, new OpenOption[0]);
            try {
                HashMap<TermId, Collection<GeneIdentifier>> orphaDiseaseToGeneBuilder = new HashMap<TermId, Collection<GeneIdentifier>>();
                XMLEventReader eventReader = XMLInputFactory.newInstance().createXMLEventReader(in);
                String currentOrphanum = null;
                String currentDiseasename = null;
                String currentGeneSymbol = null;
                String currentOmimId = null;
                while (eventReader.hasNext()) {
                    XMLEvent event = eventReader.nextEvent();
                    if (event.isStartElement()) {
                        String localPart = event.asStartElement().getName().getLocalPart();
                        if (inGeneList) continue;
                        if (localPart.equals(DISORDER)) {
                            inDisorder = true;
                            continue;
                        }
                        if (inDisorder && !inGeneList && !inDisorderGeneAssociationList && localPart.equals(ORPHA_NUMBER)) {
                            event = eventReader.nextEvent();
                            currentOrphanum = event.asCharacters().getData();
                            continue;
                        }
                        if (inDisorder && !inGeneList && !inDisorderGeneAssociationList && localPart.equals(NAME)) {
                            event = eventReader.nextEvent();
                            currentDiseasename = event.asCharacters().getData();
                            continue;
                        }
                        if (inDisorder && !inGeneList && !inDisorderGeneAssociationList && localPart.equals(GENE_LIST)) {
                            inGeneList = true;
                            continue;
                        }
                        if (localPart.equals(DISORDER_GENE_ASSOCIATION_LIST)) {
                            inDisorderGeneAssociationList = true;
                            continue;
                        }
                        if (inDisorderGeneAssociationList && localPart.equals(DISORDER_GENE_ASSOCIATION)) {
                            inDisorderGeneAssociation = true;
                            continue;
                        }
                        if (inDisorderGeneAssociation && localPart.equals(GENE)) {
                            inGene = true;
                            continue;
                        }
                        if (inDisorderGeneAssociation && localPart.equals(EXTERNAL_REFERENCE)) {
                            inExternalReference = true;
                            continue;
                        }
                        if (inExternalReference && localPart.equals(SOURCE)) {
                            event = eventReader.nextEvent();
                            String sourceString = event.asCharacters().getData();
                            if (!sourceString.equals("OMIM")) continue;
                            inOMIMReference = true;
                            continue;
                        }
                        if (inOMIMReference && localPart.equals(REFERENCE)) {
                            event = eventReader.nextEvent();
                            currentOmimId = event.asCharacters().getData();
                            continue;
                        }
                        if (!inDisorder || !inDisorderGeneAssociation || !inDisorderGeneAssociationList || !inGene || !localPart.equals(SYMBOL)) continue;
                        event = eventReader.nextEvent();
                        currentGeneSymbol = event.asCharacters().getData();
                        continue;
                    }
                    if (!event.isEndElement()) continue;
                    EndElement endElement = event.asEndElement();
                    String localPart = endElement.getName().getLocalPart();
                    if (localPart.equals(DISORDER)) {
                        inDisorder = false;
                        continue;
                    }
                    if (localPart.equals(GENE_LIST)) {
                        inGeneList = false;
                        continue;
                    }
                    if (localPart.equals(EXTERNAL_REFERENCE)) {
                        inExternalReference = false;
                        inOMIMReference = false;
                        continue;
                    }
                    if (localPart.equals(DISORDER_GENE_ASSOCIATION_LIST)) {
                        inDisorderGeneAssociationList = false;
                        currentOrphanum = null;
                        currentOmimId = null;
                        currentDiseasename = null;
                        continue;
                    }
                    if (localPart.equals(DISORDER_GENE_ASSOCIATION)) {
                        inDisorderGeneAssociation = false;
                        if (currentOrphanum != null && currentDiseasename != null && currentGeneSymbol != null) {
                            TermId orphaId = TermId.of((String)"ORPHA", (String)currentOrphanum);
                            Collection<TermId> geneIds = mimIdToGeneIdMap.get(currentOmimId);
                            if (currentOmimId == null || geneIds == null) {
                                GeneIdentifier geneId = symbolToGeneId.get(currentGeneSymbol);
                                if (geneId != null) {
                                    orphaDiseaseToGeneBuilder.computeIfAbsent(orphaId, k -> new HashSet()).add(geneId);
                                } else {
                                    LOGGER.warn("Could not find gene id for {}", (Object)currentGeneSymbol);
                                }
                            } else {
                                for (TermId geneId : geneIds) {
                                    GeneIdentifier g = GeneIdentifier.of(geneId, currentGeneSymbol);
                                    orphaDiseaseToGeneBuilder.computeIfAbsent(orphaId, k -> new HashSet()).add(g);
                                }
                            }
                        }
                        currentGeneSymbol = null;
                        currentOmimId = null;
                        continue;
                    }
                    if (!endElement.getName().getLocalPart().equals(GENE)) continue;
                    inGene = false;
                }
                map = OrphaGeneToDiseaseParser.makeUnmodifiable(orphaDiseaseToGeneBuilder);
                if (in == null) break block31;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMLStreamException e) {
                    throw new PhenolRuntimeException("Could not parse orpha disease to gene xml: " + e.getMessage());
                }
            }
            in.close();
        }
        return map;
    }

    private static Map<TermId, Collection<GeneIdentifier>> makeUnmodifiable(Map<TermId, Collection<GeneIdentifier>> orphaDiseaseToGeneBuilder) {
        HashMap<TermId, List<GeneIdentifier>> orphaDiseaseToGene = new HashMap<TermId, List<GeneIdentifier>>(orphaDiseaseToGeneBuilder.size(), 0.9f);
        for (Map.Entry<TermId, Collection<GeneIdentifier>> e : orphaDiseaseToGeneBuilder.entrySet()) {
            orphaDiseaseToGene.put(e.getKey(), List.copyOf(e.getValue()));
        }
        return Collections.unmodifiableMap(orphaDiseaseToGene);
    }

    private static Map<String, TermId> initMissingGeneIdMap() {
        HashMap<String, TermId> symbolToGeneIdMap = new HashMap<String, TermId>();
        symbolToGeneIdMap.put("ATP5F1D", TermId.of((String)"NCBIGene:513"));
        symbolToGeneIdMap.put("CHD1", TermId.of((String)"NCBIGene:1105"));
        symbolToGeneIdMap.put("CD55", TermId.of((String)"NCBIGene:1604"));
        symbolToGeneIdMap.put("DLST", TermId.of((String)"NCBIGene:1743"));
        symbolToGeneIdMap.put("EPHB4", TermId.of((String)"NCBIGene:2050"));
        symbolToGeneIdMap.put("HLA-DPA1", TermId.of((String)"NCBIGene:3113"));
        symbolToGeneIdMap.put("IGH", TermId.of((String)"NCBIGene:3492"));
        symbolToGeneIdMap.put("OPA2", TermId.of((String)"NCBIGene:4977"));
        symbolToGeneIdMap.put("PIK3C2A", TermId.of((String)"NCBIGene:5286"));
        symbolToGeneIdMap.put("ROS1", TermId.of((String)"NCBIGene:6098"));
        symbolToGeneIdMap.put("TRA", TermId.of((String)"NCBIGene:6955"));
        symbolToGeneIdMap.put("TRB", TermId.of((String)"NCBIGene:6957"));
        symbolToGeneIdMap.put("TRD", TermId.of((String)"NCBIGene:6964"));
        symbolToGeneIdMap.put("TRG", TermId.of((String)"NCBIGene:6965"));
        symbolToGeneIdMap.put("USH1E", TermId.of((String)"NCBIGene:7396"));
        symbolToGeneIdMap.put("RIPK1", TermId.of((String)"NCBIGene:8737"));
        symbolToGeneIdMap.put("PLAA", TermId.of((String)"NCBIGene:9373"));
        symbolToGeneIdMap.put("SH3PXD2A", TermId.of((String)"NCBIGene:9644"));
        symbolToGeneIdMap.put("CWC27", TermId.of((String)"NCBIGene:10283"));
        symbolToGeneIdMap.put("YME1L1", TermId.of((String)"NCBIGene:10730"));
        symbolToGeneIdMap.put("RPL35", TermId.of((String)"NCBIGene:11224"));
        symbolToGeneIdMap.put("RRAS2", TermId.of((String)"NCBIGene:22800"));
        symbolToGeneIdMap.put("MRAS", TermId.of((String)"NCBIGene:22808"));
        symbolToGeneIdMap.put("DUX4L1", TermId.of((String)"NCBIGene:22947"));
        symbolToGeneIdMap.put("NCAPD3", TermId.of((String)"NCBIGene:23310"));
        symbolToGeneIdMap.put("IGHV4-34", TermId.of((String)"NCBIGene:28395"));
        symbolToGeneIdMap.put("IGHV3-21", TermId.of((String)"NCBIGene:28444"));
        symbolToGeneIdMap.put("PUS7", TermId.of((String)"NCBIGene:54517"));
        symbolToGeneIdMap.put("TBC1D8B", TermId.of((String)"NCBIGene:54885"));
        symbolToGeneIdMap.put("TRPV6", TermId.of((String)"NCBIGene:55503"));
        symbolToGeneIdMap.put("RNPC3", TermId.of((String)"NCBIGene:55599"));
        symbolToGeneIdMap.put("SPG14", TermId.of((String)"NCBIGene:57309"));
        symbolToGeneIdMap.put("SPG16", TermId.of((String)"NCBIGene:57760"));
        symbolToGeneIdMap.put("RINT1", TermId.of((String)"NCBIGene:60561"));
        symbolToGeneIdMap.put("GINGF2", TermId.of((String)"NCBIGene:64644"));
        symbolToGeneIdMap.put("MMEL1", TermId.of((String)"NCBIGene:79258"));
        symbolToGeneIdMap.put("GREB1L", TermId.of((String)"NCBIGene:80000"));
        symbolToGeneIdMap.put("USP45", TermId.of((String)"NCBIGene:85015"));
        symbolToGeneIdMap.put("CFAP300", TermId.of((String)"NCBIGene:85016"));
        symbolToGeneIdMap.put("ALKBH8", TermId.of((String)"NCBIGene:91801"));
        symbolToGeneIdMap.put("STRADA", TermId.of((String)"NCBIGene:92335"));
        symbolToGeneIdMap.put("TIMM50", TermId.of((String)"NCBIGene:92609"));
        symbolToGeneIdMap.put("DYT13", TermId.of((String)"NCBIGene:93983"));
        symbolToGeneIdMap.put("GPRASP2", TermId.of((String)"NCBIGene:114928"));
        symbolToGeneIdMap.put("TDRD9", TermId.of((String)"NCBIGene:122402"));
        symbolToGeneIdMap.put("NAXE", TermId.of((String)"NCBIGene:128240"));
        symbolToGeneIdMap.put("TRIM71", TermId.of((String)"NCBIGene:131405"));
        symbolToGeneIdMap.put("SPG19", TermId.of((String)"NCBIGene:140907"));
        symbolToGeneIdMap.put("WDR66", TermId.of((String)"NCBIGene:144406"));
        symbolToGeneIdMap.put("POLR3H", TermId.of((String)"NCBIGene:171568"));
        symbolToGeneIdMap.put("CFAP221", TermId.of((String)"NCBIGene:200373"));
        symbolToGeneIdMap.put("RNU12", TermId.of((String)"NCBIGene:267010"));
        symbolToGeneIdMap.put("NUTM2E", TermId.of((String)"NCBIGene:283008"));
        symbolToGeneIdMap.put("DYT15", TermId.of((String)"NCBIGene:317714"));
        symbolToGeneIdMap.put("UBAC2", TermId.of((String)"NCBIGene:337867"));
        symbolToGeneIdMap.put("SPG24", TermId.of((String)"NCBIGene:338090"));
        symbolToGeneIdMap.put("SCA25", TermId.of((String)"NCBIGene:338435"));
        symbolToGeneIdMap.put("SPG25", TermId.of((String)"NCBIGene:387583"));
        symbolToGeneIdMap.put("LIPT2", TermId.of((String)"NCBIGene:387787"));
        symbolToGeneIdMap.put("SCA20", TermId.of((String)"NCBIGene:407973"));
        symbolToGeneIdMap.put("SPG27", TermId.of((String)"NCBIGene:414886"));
        symbolToGeneIdMap.put("SPG29", TermId.of((String)"NCBIGene:619379"));
        symbolToGeneIdMap.put("SPG32", TermId.of((String)"NCBIGene:724107"));
        symbolToGeneIdMap.put("SPG34", TermId.of((String)"NCBIGene:724110"));
        symbolToGeneIdMap.put("NUTM2A", TermId.of((String)"NCBIGene:728118"));
        symbolToGeneIdMap.put("NUTM2B", TermId.of((String)"NCBIGene:729262"));
        symbolToGeneIdMap.put("SPG36", TermId.of((String)"NCBIGene:791228"));
        symbolToGeneIdMap.put("SPG37", TermId.of((String)"NCBIGene:100049159"));
        symbolToGeneIdMap.put("SPG38", TermId.of((String)"NCBIGene:100049707"));
        symbolToGeneIdMap.put("DYT17", TermId.of((String)"NCBIGene:100216344"));
        symbolToGeneIdMap.put("USH1H", TermId.of((String)"NCBIGene:100271837"));
        symbolToGeneIdMap.put("SCA30", TermId.of((String)"NCBIGene:100359393"));
        symbolToGeneIdMap.put("DYT21", TermId.of((String)"NCBIGene:100885773"));
        symbolToGeneIdMap.put("USH1K", TermId.of((String)"NCBIGene:101180907"));
        symbolToGeneIdMap.put("IL12A-AS1", TermId.of((String)"NCBIGene:101928376"));
        symbolToGeneIdMap.put("SCA37", TermId.of((String)"NCBIGene:103753527"));
        return symbolToGeneIdMap;
    }
}

