/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;

class TemporalIntervalDefault
implements TemporalInterval {
    private final Age start;
    private final Age end;

    static TemporalInterval of(Age start, Age end) {
        if (start.isOpen() || end.isOpen()) {
            if (!start.isOpen()) {
                return new TemporalIntervalOpenEnd(start);
            }
            if (!end.isOpen()) {
                return new TemporalIntervalOpenStart(end);
            }
            return TemporalIntervalOpen.instance();
        }
        return new TemporalIntervalDefault(start, end);
    }

    private TemporalIntervalDefault(Age start, Age end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public Age start() {
        return this.start;
    }

    @Override
    public Age end() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporalIntervalDefault that = (TemporalIntervalDefault)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "DefaultTemporalInterval{start=" + this.start + ", end=" + this.end + "}";
    }

    private static class TemporalIntervalOpenEnd
    implements TemporalInterval {
        private final Age start;

        private TemporalIntervalOpenEnd(Age start) {
            this.start = start;
        }

        @Override
        public Age start() {
            return this.start;
        }

        @Override
        public Age end() {
            return Age.openEnd();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemporalIntervalOpenEnd that = (TemporalIntervalOpenEnd)o;
            return Objects.equals(this.start, that.start);
        }

        public int hashCode() {
            return Objects.hash(this.start);
        }

        public String toString() {
            return "OpenEndTemporalInterval{start=" + this.start + "}";
        }
    }

    private static class TemporalIntervalOpenStart
    implements TemporalInterval {
        private final Age end;

        private TemporalIntervalOpenStart(Age end) {
            this.end = end;
        }

        @Override
        public Age start() {
            return Age.openStart();
        }

        @Override
        public Age end() {
            return this.end;
        }

        public int hashCode() {
            return Objects.hash(this.end);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemporalIntervalOpenStart that = (TemporalIntervalOpenStart)o;
            return Objects.equals(this.end, that.end);
        }

        public String toString() {
            return "OpenStartTemporalInterval{end=" + this.end + "}";
        }
    }

    private static class TemporalIntervalOpen
    implements TemporalInterval {
        private static final TemporalIntervalOpen INSTANCE = new TemporalIntervalOpen();

        static TemporalIntervalOpen instance() {
            return INSTANCE;
        }

        private TemporalIntervalOpen() {
        }

        @Override
        public Age start() {
            return Age.openStart();
        }

        @Override
        public Age end() {
            return Age.openEnd();
        }

        public String toString() {
            return "OpenTemporalInterval";
        }
    }
}

