/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class GeneIdentifiers
implements Iterable<GeneIdentifier> {
    private final List<GeneIdentifier> geneIdentifiers;
    private volatile Map<TermId, String> geneIdToSymbol = null;
    private volatile Map<String, GeneIdentifier> symbolToGeneIdentifier = null;

    public static GeneIdentifiers of(List<GeneIdentifier> geneIdentifiers) {
        return new GeneIdentifiers(geneIdentifiers);
    }

    private GeneIdentifiers(List<GeneIdentifier> geneIdentifiers) {
        this.geneIdentifiers = Objects.requireNonNull(geneIdentifiers, "Gene identifiers must not be null");
    }

    public List<GeneIdentifier> geneIdentifiers() {
        return this.geneIdentifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TermId, String> geneIdToSymbol() {
        if (this.geneIdToSymbol == null) {
            GeneIdentifiers geneIdentifiers = this;
            synchronized (geneIdentifiers) {
                if (this.geneIdToSymbol == null) {
                    this.geneIdToSymbol = this.geneIdentifiers.stream().collect(Collectors.toUnmodifiableMap(GeneIdentifier::id, GeneIdentifier::symbol));
                }
            }
        }
        return this.geneIdToSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GeneIdentifier> symbolToGeneIdentifier() {
        if (this.symbolToGeneIdentifier == null) {
            GeneIdentifiers geneIdentifiers = this;
            synchronized (geneIdentifiers) {
                if (this.symbolToGeneIdentifier == null) {
                    this.symbolToGeneIdentifier = this.geneIdentifiers.stream().collect(Collectors.toUnmodifiableMap(GeneIdentifier::symbol, Function.identity()));
                }
            }
        }
        return this.symbolToGeneIdentifier;
    }

    @Override
    public Iterator<GeneIdentifier> iterator() {
        return this.geneIdentifiers.iterator();
    }

    public int size() {
        return this.geneIdentifiers.size();
    }
}

