/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociation;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociationsDefault;
import org.monarchinitiative.phenol.annotations.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface DiseaseToGeneAssociations
extends Iterable<DiseaseToGeneAssociation> {
    public static DiseaseToGeneAssociations of(List<DiseaseToGeneAssociation> diseaseToGeneAssociations) {
        return DiseaseToGeneAssociationsDefault.of(diseaseToGeneAssociations);
    }

    public Stream<DiseaseToGeneAssociation> diseaseToGeneAssociations();

    default public Map<TermId, Collection<GeneIdentifier>> diseaseIdToGeneIds() {
        HashMap diseaseIdToGeneIdsBuilder = new HashMap();
        for (DiseaseToGeneAssociation diseaseToGeneAssociation : this) {
            List geneIds = diseaseToGeneAssociation.associations().stream().map(GeneToAssociation::geneIdentifier).collect(Collectors.toUnmodifiableList());
            diseaseIdToGeneIdsBuilder.put(diseaseToGeneAssociation.diseaseId(), geneIds);
        }
        return Map.copyOf(diseaseIdToGeneIdsBuilder);
    }

    default public Map<TermId, Collection<TermId>> geneIdToDiseaseIds() {
        HashMap<TermId, Collection> geneIdToDiseaseIdsBuilder = new HashMap<TermId, Collection>();
        for (DiseaseToGeneAssociation diseaseToGeneAssociation : this) {
            for (GeneToAssociation geneToAssociation : diseaseToGeneAssociation.associations()) {
                geneIdToDiseaseIdsBuilder.computeIfAbsent(geneToAssociation.geneIdentifier().id(), k -> new HashSet()).add(diseaseToGeneAssociation.diseaseId());
            }
        }
        return geneIdToDiseaseIdsBuilder.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> List.copyOf((Collection)e.getValue())));
    }

    default public Map<TermId, Collection<GeneToAssociation>> diseaseIdToGeneAssociations() {
        return this.diseaseToGeneAssociations().collect(Collectors.toUnmodifiableMap(DiseaseToGeneAssociation::diseaseId, DiseaseToGeneAssociation::associations));
    }
}

