/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.hpo.AssociationType;

public class GeneToAssociation {
    private final GeneIdentifier geneIdentifier;
    private final AssociationType associationType;

    public static GeneToAssociation of(GeneIdentifier geneIdentifier, AssociationType at) {
        return new GeneToAssociation(geneIdentifier, at);
    }

    private GeneToAssociation(GeneIdentifier geneIdentifier, AssociationType associationType) {
        this.geneIdentifier = Objects.requireNonNull(geneIdentifier, "Gene identifier must not be null");
        this.associationType = Objects.requireNonNull(associationType, "Association type must not be null");
    }

    public GeneIdentifier geneIdentifier() {
        return this.geneIdentifier;
    }

    public AssociationType associationType() {
        return this.associationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneToAssociation that = (GeneToAssociation)o;
        return Objects.equals(this.geneIdentifier, that.geneIdentifier) && this.associationType == that.associationType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.geneIdentifier, this.associationType});
    }

    public String toString() {
        return this.geneIdentifier.symbol() + " [" + this.associationType + "]";
    }
}

