/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociation;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociations;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAssociationDataDefault;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface HpoAssociationData {
    public static HpoAssociationData of(List<GeneIdentifier> geneIdentifiers, Map<TermId, Collection<GeneIdentifier>> diseaseToGenes, Map<TermId, Collection<TermId>> geneToDiseases, List<HpoGeneAnnotation> phenotypeToGene, DiseaseToGeneAssociations associations) {
        return new HpoAssociationDataDefault(geneIdentifiers, diseaseToGenes, geneToDiseases, phenotypeToGene, associations);
    }

    public List<GeneIdentifier> geneIdentifiers();

    public Map<TermId, Collection<GeneIdentifier>> diseaseToGenes();

    public Map<TermId, Collection<TermId>> geneToDiseases();

    public List<HpoGeneAnnotation> phenotypeToGene();

    public DiseaseToGeneAssociations associations();

    default public Map<TermId, String> geneIdToSymbol() {
        return this.geneIdentifiers().stream().collect(Collectors.toUnmodifiableMap(GeneIdentifier::id, GeneIdentifier::symbol));
    }

    default public Map<TermId, DiseaseToGeneAssociation> associationsByDiseaseId() {
        return this.associations().diseaseToGeneAssociations().collect(Collectors.toUnmodifiableMap(DiseaseToGeneAssociation::diseaseId, Function.identity()));
    }
}

