/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.hpo.DiseaseToGeneAssociations;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAssociationData;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoAssociationDataDefault
implements HpoAssociationData {
    private final List<GeneIdentifier> geneIdentifiers;
    private final Map<TermId, Collection<GeneIdentifier>> diseaseToGenes;
    private final Map<TermId, Collection<TermId>> geneToDiseases;
    private final List<HpoGeneAnnotation> phenotypeToGene;
    private final DiseaseToGeneAssociations associations;

    HpoAssociationDataDefault(List<GeneIdentifier> geneIdentifiers, Map<TermId, Collection<GeneIdentifier>> diseaseToGenes, Map<TermId, Collection<TermId>> geneToDiseases, List<HpoGeneAnnotation> phenotypeToGene, DiseaseToGeneAssociations associations) {
        this.geneIdentifiers = Objects.requireNonNull(geneIdentifiers, "Gene identifiers must not be null");
        this.diseaseToGenes = Objects.requireNonNull(diseaseToGenes, "Disease to genes must not be null");
        this.geneToDiseases = Objects.requireNonNull(geneToDiseases, "Gene to diseases must not be null");
        this.phenotypeToGene = Objects.requireNonNull(phenotypeToGene, "Phenotype to gene must not be null");
        this.associations = Objects.requireNonNull(associations, "Associations must not be null");
    }

    @Override
    public List<GeneIdentifier> geneIdentifiers() {
        return this.geneIdentifiers;
    }

    @Override
    public Map<TermId, Collection<GeneIdentifier>> diseaseToGenes() {
        return this.diseaseToGenes;
    }

    @Override
    public Map<TermId, Collection<TermId>> geneToDiseases() {
        return this.geneToDiseases;
    }

    @Override
    public List<HpoGeneAnnotation> phenotypeToGene() {
        return this.phenotypeToGene;
    }

    @Override
    public DiseaseToGeneAssociations associations() {
        return this.associations;
    }
}

