/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseDefault;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface HpoDisease
extends Identified {
    public static HpoDisease of(TermId diseaseId, String name, TemporalInterval globalOnset, List<HpoDiseaseAnnotation> phenotypicAbnormalities, List<TermId> modesOfInheritance) {
        return new HpoDiseaseDefault(diseaseId, name, globalOnset, phenotypicAbnormalities, modesOfInheritance);
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public TermId diseaseDatabaseTermId() {
        return this.id();
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public TermId getDiseaseDatabaseTermId() {
        return this.id();
    }

    public String diseaseName();

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public String getName() {
        return this.diseaseName();
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public String getDiseaseName() {
        return this.diseaseName();
    }

    public Optional<TemporalInterval> globalOnset();

    public List<TermId> modesOfInheritance();

    @Deprecated(forRemoval=true, since="2.0.0-RC2")
    default public List<TermId> getModesOfInheritance() {
        return this.modesOfInheritance();
    }

    public Iterator<HpoDiseaseAnnotation> phenotypicAbnormalities();

    public int phenotypicAbnormalitiesCount();

    default public Stream<HpoDiseaseAnnotation> phenotypicAbnormalitiesStream() {
        return StreamSupport.stream(Spliterators.spliterator(this.phenotypicAbnormalities(), (long)this.phenotypicAbnormalitiesCount(), 0), false);
    }

    default public Stream<HpoDiseaseAnnotation> absentPhenotypicAbnormalitiesStream() {
        return this.phenotypicAbnormalitiesStream().filter(a -> a.ratio().map(Ratio::isZero).orElse(false));
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public List<TermId> negativeAnnotations() {
        return this.absentPhenotypicAbnormalitiesStream().map(Identified::id).collect(Collectors.toList());
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public List<TermId> getNegativeAnnotations() {
        return this.negativeAnnotations();
    }

    default public Optional<HpoDiseaseAnnotation> getAnnotation(TermId termId) {
        return this.phenotypicAbnormalitiesStream().filter(diseaseAnnotation -> diseaseAnnotation.id().equals((Object)termId)).findAny();
    }

    default public Optional<Ratio> getFrequencyOfTermInDisease(TermId termId) {
        return this.phenotypicAbnormalitiesStream().filter(diseaseAnnotation -> diseaseAnnotation.id().equals((Object)termId)).findFirst().flatMap(HpoDiseaseAnnotation::ratio);
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public List<TermId> getPhenotypicAbnormalityTermIdList() {
        return this.getPhenotypicAbnormalityTermIds().collect(Collectors.toList());
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public Stream<TermId> getPhenotypicAbnormalityTermIds() {
        return this.phenotypicAbnormalityTermIds();
    }

    default public Stream<TermId> phenotypicAbnormalityTermIds() {
        return this.phenotypicAbnormalitiesStream().map(Identified::id);
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public long getNumberOfPhenotypeAnnotations() {
        return this.phenotypicAbnormalitiesCount();
    }

    default public boolean isDirectlyAnnotatedTo(TermId termId) {
        return this.phenotypicAbnormalitiesStream().anyMatch(annotation -> annotation.id().equals((Object)termId));
    }

    default public boolean isDirectlyAnnotatedToAnyOf(Set<TermId> termIds) {
        return this.phenotypicAbnormalitiesStream().anyMatch(tiwm -> termIds.contains(tiwm.id()));
    }
}

