/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationDefault;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationMetadata;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface HpoDiseaseAnnotation
extends Identified,
Comparable<HpoDiseaseAnnotation> {
    public static HpoDiseaseAnnotation of(TermId termId, Collection<HpoDiseaseAnnotationMetadata> metadata) {
        float frequency = metadata.stream().map(meta -> meta.frequency().ratio()).flatMap(Optional::stream).reduce(Ratio::combine).map(Ratio::frequency).orElse(Float.valueOf(0.0f)).floatValue();
        if ((double)frequency > 1.0) {
            throw new IllegalArgumentException("Total frequency cannot be greater than 1: " + frequency);
        }
        return HpoDiseaseAnnotationDefault.of(termId, metadata);
    }

    @Deprecated(since="2.0.0-RC1", forRemoval=true)
    default public TermId termId() {
        return this.id();
    }

    public Stream<HpoDiseaseAnnotationMetadata> metadata();

    public Optional<Ratio> ratio();

    default public Optional<Float> frequency() {
        return this.ratio().map(Ratio::frequency);
    }

    public List<TemporalInterval> observationIntervals();

    public Optional<Ratio> observedInInterval(TemporalInterval var1);

    default public Optional<Age> earliestOnset() {
        return this.metadata().filter(meta -> meta.frequency().numerator().map(numerator -> numerator != 0).orElse(false)).map(HpoDiseaseAnnotationMetadata::observationInterval).flatMap(Optional::stream).map(TemporalInterval::start).min(Age::compare);
    }

    default public Optional<Age> latestOnset() {
        return this.metadata().filter(meta -> meta.frequency().numerator().map(numerator -> numerator != 0).orElse(false)).map(HpoDiseaseAnnotationMetadata::observationInterval).flatMap(Optional::stream).map(TemporalInterval::start).max(Age::compare);
    }

    default public Optional<Age> earliestResolution() {
        return this.metadata().filter(meta -> meta.frequency().numerator().map(numerator -> numerator != 0).orElse(false)).map(HpoDiseaseAnnotationMetadata::observationInterval).flatMap(Optional::stream).map(TemporalInterval::end).min(Age::compare);
    }

    default public Optional<Age> latestResolution() {
        return this.metadata().filter(meta -> meta.frequency().numerator().map(numerator -> numerator != 0).orElse(false)).map(HpoDiseaseAnnotationMetadata::observationInterval).flatMap(Optional::stream).map(TemporalInterval::end).max(Age::compare);
    }
}

