/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.Sex;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationMetadata;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoDiseaseAnnotationMetadataDefault
implements HpoDiseaseAnnotationMetadata {
    private final TemporalInterval temporalInterval;
    private final AnnotationFrequency diseaseAnnotationFrequency;
    private final Collection<TermId> modifiers;
    private final Sex sex;

    HpoDiseaseAnnotationMetadataDefault(TemporalInterval temporalInterval, AnnotationFrequency diseaseAnnotationFrequency, Collection<TermId> modifiers, Sex sex) {
        this.temporalInterval = temporalInterval;
        this.diseaseAnnotationFrequency = Objects.requireNonNull(diseaseAnnotationFrequency, "Frequency cannot be null");
        this.modifiers = Objects.requireNonNull(modifiers, "Modifiers collection cannot be null");
        this.sex = sex;
    }

    @Override
    public Optional<TemporalInterval> observationInterval() {
        return Optional.ofNullable(this.temporalInterval);
    }

    @Override
    public AnnotationFrequency frequency() {
        return this.diseaseAnnotationFrequency;
    }

    @Override
    public Collection<TermId> modifiers() {
        return this.modifiers;
    }

    @Override
    public Optional<Sex> sex() {
        return Optional.ofNullable(this.sex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HpoDiseaseAnnotationMetadataDefault that = (HpoDiseaseAnnotationMetadataDefault)o;
        return Objects.equals(this.temporalInterval, that.temporalInterval) && Objects.equals(this.diseaseAnnotationFrequency, that.diseaseAnnotationFrequency) && Objects.equals(this.modifiers, that.modifiers) && Objects.equals((Object)this.sex, (Object)that.sex);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.temporalInterval, this.diseaseAnnotationFrequency, this.modifiers, this.sex});
    }

    public String toString() {
        return "HpoDiseaseAnnotationMetadataDefault{temporalInterval=" + this.temporalInterval + ", frequency=" + this.diseaseAnnotationFrequency + ", modifiers=" + this.modifiers + ", sex=" + this.sex + "}";
    }
}

