/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoDiseaseDefault
implements HpoDisease {
    private final TermId diseaseDatabaseId;
    private final String diseaseName;
    private final TemporalInterval onset;
    private final List<HpoDiseaseAnnotation> phenotypicAbnormalities;
    private final List<TermId> modesOfInheritance;

    HpoDiseaseDefault(TermId diseaseDatabaseId, String diseaseName, TemporalInterval onset, List<HpoDiseaseAnnotation> phenotypicAbnormalities, List<TermId> modesOfInheritance) {
        this.diseaseDatabaseId = Objects.requireNonNull(diseaseDatabaseId, "Disease database ID must not be null");
        this.diseaseName = Objects.requireNonNull(diseaseName, "Name must not be null");
        this.onset = onset;
        this.phenotypicAbnormalities = Objects.requireNonNull(phenotypicAbnormalities, "Phenotypic abnormalities must not be null");
        this.modesOfInheritance = Objects.requireNonNull(modesOfInheritance, "Modes of inheritance must not be null");
    }

    public TermId id() {
        return this.diseaseDatabaseId;
    }

    @Override
    public String diseaseName() {
        return this.diseaseName;
    }

    @Override
    public List<TermId> modesOfInheritance() {
        return this.modesOfInheritance;
    }

    @Override
    public Iterator<HpoDiseaseAnnotation> phenotypicAbnormalities() {
        return this.phenotypicAbnormalities.iterator();
    }

    @Override
    public int phenotypicAbnormalitiesCount() {
        return this.phenotypicAbnormalities.size();
    }

    @Override
    public Optional<TemporalInterval> globalOnset() {
        return Optional.ofNullable(this.onset);
    }

    private boolean isAnnotatedTo(TermId tid, Ontology ontology) {
        List direct = this.getPhenotypicAbnormalityTermIds().collect(Collectors.toList());
        Set ancs = ontology.getAllAncestorTermIds(direct, true);
        return ancs.contains(tid);
    }

    private double getFrequencyOfTermInDiseaseWithAnnotationPropagation(TermId tid, Ontology ontology) {
        return Double.NaN;
    }

    public String toString() {
        String abnormalityList = this.phenotypicAbnormalities.stream().map(f -> f.id().getValue()).collect(Collectors.joining(";"));
        return String.format("HpoDisease [name=%s;%s] phenotypicAbnormalities=%s, globalOnset=%s, modesOfInheritance=%s", this.diseaseName, this.diseaseDatabaseId.getValue(), abnormalityList, this.onset, this.modesOfInheritance);
    }
}

