/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.constants.hpo.HpoFrequencyTermIds;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

public enum HpoFrequency implements Identified,
AnnotationFrequency
{
    OBLIGATE(HpoFrequencyTermIds.OBLIGATE, "Obligate", Ratio.of(50, 50)),
    VERY_FREQUENT(HpoFrequencyTermIds.VERY_FREQUENT, "Very frequent", Ratio.of(45, 50)),
    FREQUENT(HpoFrequencyTermIds.FREQUENT, "Frequent", Ratio.of(27, 50)),
    OCCASIONAL(HpoFrequencyTermIds.OCCASIONAL, "Occasional", Ratio.of(20, 50)),
    VERY_RARE(HpoFrequencyTermIds.VERY_RARE, "Very rare", Ratio.of(2, 50)),
    EXCLUDED(HpoFrequencyTermIds.EXCLUDED, "Excluded", Ratio.of(0, 50));

    private final TermId termId;
    private final String label;
    private final Ratio ratio;

    private HpoFrequency(TermId termId, String label, Ratio ratio) {
        this.termId = termId;
        this.label = label;
        this.ratio = ratio;
    }

    @Deprecated
    public TermId termId() {
        return this.termId;
    }

    public TermId id() {
        return this.termId;
    }

    public String label() {
        return this.label;
    }

    @Override
    public float frequency() {
        switch (this) {
            case EXCLUDED: {
                return 0.0f;
            }
            case VERY_RARE: {
                return 0.024999999f;
            }
            case OCCASIONAL: {
                return 0.17f;
            }
            case FREQUENT: {
                return 0.545f;
            }
            case VERY_FREQUENT: {
                return 0.895f;
            }
        }
        return 1.0f;
    }

    @Override
    public Optional<Ratio> ratio() {
        return Optional.of(this.ratio);
    }

    @Deprecated
    public float mean() {
        return this.frequency();
    }

    public static HpoFrequency fromTermId(TermId termId) throws IllegalArgumentException {
        switch (termId.getValue()) {
            case "HP:0040280": {
                return OBLIGATE;
            }
            case "HP:0040281": {
                return VERY_FREQUENT;
            }
            case "HP:0040282": {
                return FREQUENT;
            }
            case "HP:0040283": {
                return OCCASIONAL;
            }
            case "HP:0040284": {
                return VERY_RARE;
            }
            case "HP:0040285": {
                return EXCLUDED;
            }
        }
        throw new IllegalArgumentException("TermId " + termId + " is not a valid frequency sub ontology term ID");
    }

    public String toString() {
        return this.label + " (" + this.termId + ")";
    }
}

