/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.constants.hpo.HpoOnsetTermIds;
import org.monarchinitiative.phenol.ontology.data.TermId;

public enum HpoOnset implements TemporalInterval
{
    ANTENATAL_ONSET(Age.lastMenstrualPeriod(), Age.birth()),
    EMBRYONAL_ONSET(Age.lastMenstrualPeriod(), Age.gestational(10, 0)),
    FETAL_ONSET(Age.gestational(10, 0), Age.birth()),
    CONGENITAL_ONSET(Age.birth(), Age.birth()),
    NEONATAL_ONSET(Age.birth(), Age.postnatal(29)),
    PEDIATRIC_ONSET(Age.postnatal(29), Age.postnatal(16, 0, 0)),
    INFANTILE_ONSET(Age.postnatal(29), Age.postnatal(1, 0, 0)),
    CHILDHOOD_ONSET(Age.postnatal(1, 0, 0), Age.postnatal(5, 0, 0)),
    JUVENILE_ONSET(Age.postnatal(5, 0, 0), Age.postnatal(16, 0, 0)),
    ADULT_ONSET(Age.postnatal(16, 0, 0), Age.openEnd()),
    YOUNG_ADULT_ONSET(Age.postnatal(16, 0, 0), Age.postnatal(40, 0, 0)),
    MIDDLE_AGE_ONSET(Age.postnatal(40, 0, 0), Age.postnatal(60, 0, 0)),
    LATE_ONSET(Age.postnatal(60, 0, 0), Age.openEnd());

    private final Age start;
    private final Age end;

    private HpoOnset(Age start, Age end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public Age start() {
        return this.start;
    }

    @Override
    public Age end() {
        return this.end;
    }

    public static Optional<HpoOnset> fromTermId(TermId termId) {
        return HpoOnset.fromHpoIdString(termId.getValue());
    }

    public static Optional<HpoOnset> fromHpoIdString(String termId) {
        switch (termId) {
            case "HP:0003577": {
                return Optional.of(CONGENITAL_ONSET);
            }
            case "HP:0003581": {
                return Optional.of(ADULT_ONSET);
            }
            case "HP:0003584": {
                return Optional.of(LATE_ONSET);
            }
            case "HP:0011462": {
                return Optional.of(YOUNG_ADULT_ONSET);
            }
            case "HP:0003596": {
                return Optional.of(MIDDLE_AGE_ONSET);
            }
            case "HP:0003593": {
                return Optional.of(INFANTILE_ONSET);
            }
            case "HP:0030674": {
                return Optional.of(ANTENATAL_ONSET);
            }
            case "HP:0011460": {
                return Optional.of(EMBRYONAL_ONSET);
            }
            case "HP:0410280": {
                return Optional.of(PEDIATRIC_ONSET);
            }
            case "HP:0011461": {
                return Optional.of(FETAL_ONSET);
            }
            case "HP:0003621": {
                return Optional.of(JUVENILE_ONSET);
            }
            case "HP:0003623": {
                return Optional.of(NEONATAL_ONSET);
            }
            case "HP:0011463": {
                return Optional.of(CHILDHOOD_ONSET);
            }
        }
        return Optional.empty();
    }

    @Deprecated
    public boolean available() {
        return true;
    }

    public TermId toTermId() {
        switch (this) {
            case ANTENATAL_ONSET: {
                return HpoOnsetTermIds.ANTENATAL_ONSET;
            }
            case CONGENITAL_ONSET: {
                return HpoOnsetTermIds.CONGENITAL_ONSET;
            }
            case NEONATAL_ONSET: {
                return HpoOnsetTermIds.NEONATAL_ONSET;
            }
            case INFANTILE_ONSET: {
                return HpoOnsetTermIds.INFANTILE_ONSET;
            }
            case CHILDHOOD_ONSET: {
                return HpoOnsetTermIds.CHILDHOOD_ONSET;
            }
            case JUVENILE_ONSET: {
                return HpoOnsetTermIds.JUVENILE_ONSET;
            }
            case ADULT_ONSET: {
                return HpoOnsetTermIds.ADULT_ONSET;
            }
            case YOUNG_ADULT_ONSET: {
                return HpoOnsetTermIds.YOUNG_ADULT_ONSET;
            }
            case MIDDLE_AGE_ONSET: {
                return HpoOnsetTermIds.MIDDLE_AGE_ONSET;
            }
            case LATE_ONSET: {
                return HpoOnsetTermIds.LATE_ONSET;
            }
        }
        throw new IllegalStateException("A TermId for `" + this + "` is missing");
    }
}

