/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.hpo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoAnnotationAlgorithms {
    public static Map<TermId, Integer> countAnnotationsInDiseaseSet(Set<HpoDisease> diseaseSet, Ontology ontology, boolean propagate) {
        HashMap<TermId, Integer> annotationCounts = new HashMap<TermId, Integer>();
        for (HpoDisease disease : diseaseSet) {
            Set termset = disease.phenotypicAbnormalitiesStream().map(Identified::id).collect(Collectors.toSet());
            if (propagate) {
                termset.addAll(OntologyAlgorithm.getAncestorTerms((Ontology)ontology, termset, (boolean)false));
            }
            for (TermId tid : termset) {
                annotationCounts.putIfAbsent(tid, 0);
                int current = (Integer)annotationCounts.get(tid);
                annotationCounts.put(tid, current + 1);
            }
        }
        return annotationCounts;
    }

    public static Map<TermId, Integer> countAnnotationsInDiseaseSet(Set<HpoDisease> diseaseSet, Ontology ontology) {
        return HpoAnnotationAlgorithms.countAnnotationsInDiseaseSet(diseaseSet, ontology, true);
    }
}

