/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.hpo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationFileParser;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModel;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModelException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.Ontology;

public class HpoAnnotationFileIngestor {
    private final Ontology ontology;
    private final List<File> smallFilePaths;
    private final List<HpoAnnotationModel> smallFileList = new ArrayList<HpoAnnotationModel>();
    private final Set<String> omitEntries;
    private int n_total_annotation_lines = 0;
    private int n_total_omitted_entries = 0;
    private boolean mergeEntries = false;
    private final List<String> errors = new ArrayList<String>();

    List<HpoAnnotationModel> getSmallFileEntries() {
        return this.smallFileList;
    }

    public HpoAnnotationFileIngestor(String directoryPath, String omitFile, Ontology ontology) {
        this(directoryPath, omitFile, ontology, false);
    }

    HpoAnnotationFileIngestor(String directoryPath, Ontology ontology) {
        this(directoryPath, String.format("%s%s%s", directoryPath, File.separator, "omit-list.txt"), ontology, false);
    }

    public HpoAnnotationFileIngestor(String directoryPath, Ontology ontology, boolean merge_fr) {
        this(directoryPath, String.format("%s%s%s", directoryPath, File.separator, "omit-list.txt"), ontology, merge_fr);
    }

    public HpoAnnotationFileIngestor(String directoryPath, String omitFile, Ontology ontology, boolean merge) {
        this.omitEntries = this.getOmitEntries(omitFile);
        this.mergeEntries = merge;
        this.smallFilePaths = this.getListOfV2SmallFiles(directoryPath);
        this.ontology = ontology;
        this.inputHpoAnnotationFiles();
    }

    private void inputHpoAnnotationFiles() {
        boolean i = false;
        for (File file : this.smallFilePaths) {
            HpoAnnotationFileParser parser = new HpoAnnotationFileParser(file.getAbsolutePath(), this.ontology);
            try {
                HpoAnnotationModel smallFile = parser.parse(true);
                if (this.mergeEntries) {
                    smallFile = smallFile.getMergedModel();
                }
                this.n_total_annotation_lines += smallFile.getNumberOfAnnotations();
                this.smallFileList.add(smallFile);
            }
            catch (HpoAnnotationModelException hafe) {
                System.err.printf("[ERROR] %s: (%s)\n", file.getName(), hafe.getMessage());
            }
            catch (PhenolRuntimeException pre) {
                System.err.printf("[ERROR] PhenolRuntimeException: with file %s: %s", file, pre.getMessage());
                throw pre;
            }
        }
    }

    private Set<String> getOmitEntries(String path) {
        if (path == null || path.isEmpty()) {
            return Set.of();
        }
        HashSet<String> entrylist = new HashSet<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] A = line.split("\\s+");
                String id = A[0];
                entrylist.add(id);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errors.add(e.getMessage());
        }
        return entrylist;
    }

    int get_omitted_entry_count() {
        return this.n_total_omitted_entries;
    }

    int get_valid_smallfile_count() {
        return this.smallFilePaths.size();
    }

    private String baseName(Path path) {
        String bname = path.getFileName().toString();
        bname = bname.replace('-', ':').replace(".tab", "");
        return bname;
    }

    private List<File> getListOfV2SmallFiles(String smallFileDirectory) {
        ArrayList<File> fileNames = new ArrayList<File>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(smallFileDirectory, new String[0]));){
            for (Path path : directoryStream) {
                if (!path.toString().endsWith(".tab")) continue;
                String basename = this.baseName(path);
                if (this.omitEntries.contains(basename)) {
                    ++this.n_total_omitted_entries;
                    continue;
                }
                fileNames.add(new File(path.toString()));
            }
        }
        catch (IOException ex) {
            this.errors.add(String.format("Could not get list of small smallFilePaths from %s [%s]. Terminating...", smallFileDirectory, ex));
        }
        return fileNames;
    }
}

