/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.hpo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoFrequency;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationEntry;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoAnnotationModel {
    private final String basename;
    private List<HpoAnnotationEntry> entryList;
    private final Database database;
    private static final String EMPTY_STRING = "";
    private static final Pattern n_of_m_pattern = Pattern.compile("^(\\d+)/(\\d+?)");
    private static final Pattern percentage_pattern = Pattern.compile("^(\\d*\\.?\\d+)%");
    private static final Pattern hpoTerm_pattern = Pattern.compile("^HP:\\d{7}$");

    public String getBasename() {
        return this.basename;
    }

    public HpoAnnotationModel(String name, List<HpoAnnotationEntry> entries) {
        this.basename = name;
        this.entryList = List.copyOf(entries);
        this.database = this.basename.contains("OMIM") ? Database.OMIM : (this.basename.contains("DECIPHER") ? Database.DECIPHER : Database.UNKNOWN);
    }

    public HpoAnnotationModel mergeWithInheritanceAnnotations(Collection<HpoAnnotationEntry> inherit) {
        ArrayList<HpoAnnotationEntry> builder = new ArrayList<HpoAnnotationEntry>();
        builder.addAll(this.entryList);
        builder.addAll(inherit);
        return new HpoAnnotationModel(this.basename, List.copyOf(builder));
    }

    private HpoAnnotationModel(String base, Database db, List<HpoAnnotationEntry> entries) {
        this.basename = base;
        this.database = db;
        this.entryList = entries;
    }

    public boolean isOMIM() {
        return this.database.equals((Object)Database.OMIM);
    }

    public boolean isDECIPHER() {
        return this.database.equals((Object)Database.DECIPHER);
    }

    public List<HpoAnnotationEntry> getEntryList() {
        return this.entryList;
    }

    public int getNumberOfAnnotations() {
        return this.entryList.size();
    }

    private boolean divergentNegation(List<HpoAnnotationEntry> entrylist) {
        String firstItemNegated = entrylist.get(0).getNegation();
        if (firstItemNegated == null) {
            firstItemNegated = EMPTY_STRING;
        }
        for (int i = 1; i < entrylist.size(); ++i) {
            if (firstItemNegated.equals(entrylist.get(i).getNegation())) continue;
            return true;
        }
        return false;
    }

    private boolean divergentSex(List<HpoAnnotationEntry> entrylist) {
        String firstItemSex = entrylist.get(0).getSex();
        if (firstItemSex == null) {
            firstItemSex = EMPTY_STRING;
        }
        for (int i = 1; i < entrylist.size(); ++i) {
            if (firstItemSex.equals(entrylist.get(i).getSex())) continue;
            return true;
        }
        return false;
    }

    private boolean divergentOnset(List<HpoAnnotationEntry> entrylist) {
        String firstItemOnsetId = entrylist.get(0).getAgeOfOnsetId();
        if (firstItemOnsetId == null) {
            firstItemOnsetId = EMPTY_STRING;
        }
        for (int i = 1; i < entrylist.size(); ++i) {
            if (firstItemOnsetId.equals(entrylist.get(i).getAgeOfOnsetId())) continue;
            return true;
        }
        return false;
    }

    private String mergeFrequencies(List<HpoAnnotationEntry> entrylist) {
        int sum_of_numerators = 0;
        int sum_of_denominators = 0;
        int DEFAULT_NUMBER_OF_OBSERVATIONS = 10;
        for (HpoAnnotationEntry e : entrylist) {
            String q = e.getFrequencyModifier();
            Matcher matcher = n_of_m_pattern.matcher(q);
            Matcher percentageMatcher = percentage_pattern.matcher(q);
            Matcher termMatcher = hpoTerm_pattern.matcher(q);
            if (q.isEmpty()) {
                sum_of_numerators += 10;
                sum_of_denominators += 10;
                continue;
            }
            if (matcher.matches()) {
                String n_str = matcher.group(1);
                String m_str = matcher.group(2);
                int n = Integer.parseInt(n_str);
                int m = Integer.parseInt(m_str);
                sum_of_numerators += n;
                sum_of_denominators += m;
                continue;
            }
            if (percentageMatcher.matches()) {
                String p_str = percentageMatcher.group(1);
                double d = Double.parseDouble(p_str);
                int n = (int)Math.round(d / 10.0);
                sum_of_numerators += n;
                sum_of_denominators += 10;
                continue;
            }
            if (termMatcher.matches()) {
                TermId freqid = TermId.of((String)q);
                HpoFrequency hpofreq = HpoFrequency.fromTermId(freqid);
                double proportion = hpofreq.mean();
                int n = (int)Math.round(proportion * 10.0);
                sum_of_numerators += n;
                sum_of_denominators += 10;
                continue;
            }
            throw new PhenolRuntimeException("Could not parse frequency entry: \"" + q + "\"");
        }
        return String.format("%d/%d", sum_of_numerators, sum_of_denominators);
    }

    private String mergeModifiers(List<HpoAnnotationEntry> entrylist) {
        ArrayList<String> modifiers = new ArrayList<String>();
        for (HpoAnnotationEntry entry : entrylist) {
            String mod = entry.getModifier();
            if (mod == null || mod.isEmpty()) continue;
            modifiers.add(mod);
        }
        if (modifiers.isEmpty()) {
            return EMPTY_STRING;
        }
        return String.join((CharSequence)";", modifiers);
    }

    private String mergeDescriptions(List<HpoAnnotationEntry> entrylist) {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (HpoAnnotationEntry entry : entrylist) {
            String mod = entry.getDescription();
            if (mod == null || !mod.isEmpty()) continue;
            descriptions.add(mod);
        }
        if (descriptions.isEmpty()) {
            return EMPTY_STRING;
        }
        return String.join((CharSequence)";", descriptions);
    }

    private String mergePublications(List<HpoAnnotationEntry> entrylist) {
        HashSet<String> pubs = new HashSet<String>();
        for (HpoAnnotationEntry entry : entrylist) {
            pubs.add(entry.getPublication());
        }
        return String.join((CharSequence)";", pubs);
    }

    private String getHighestEvidenceCode(List<HpoAnnotationEntry> entrylist) {
        String evi = "IEA";
        for (HpoAnnotationEntry entry : entrylist) {
            if (entry.getEvidenceCode().equals("PCS")) {
                return "PCS";
            }
            if (!entry.getEvidenceCode().equals("TAS")) continue;
            evi = "TAS";
        }
        return evi;
    }

    private String mergeBiocuration(List<HpoAnnotationEntry> entrylist) {
        HashSet<String> biocuration = new HashSet<String>();
        for (HpoAnnotationEntry entry : entrylist) {
            biocuration.add(entry.getBiocuration());
        }
        return String.join((CharSequence)";", biocuration);
    }

    private HpoAnnotationEntry mergeEntries(List<HpoAnnotationEntry> entrylist) {
        HpoAnnotationEntry first = entrylist.get(0);
        String diseaseId = first.getDiseaseID();
        String diseaseName = first.getDiseaseName();
        TermId phenoId = first.getPhenotypeId();
        String phenoName = first.getPhenotypeLabel();
        String onsetId = first.getAgeOfOnsetId();
        String onsetName = first.getAgeOfOnsetLabel();
        String mergedFrequency = this.mergeFrequencies(entrylist);
        String sex = first.getSex();
        String negation = first.getNegation();
        String mergedModifiers = this.mergeModifiers(entrylist);
        String mergedDescriptions = this.mergeDescriptions(entrylist);
        String mergedPublications = this.mergePublications(entrylist);
        String evidence = this.getHighestEvidenceCode(entrylist);
        String mergedBiocuration = this.mergeBiocuration(entrylist);
        return new HpoAnnotationEntry(diseaseId, diseaseName, phenoId, phenoName, onsetId, onsetName, mergedFrequency, sex, negation, mergedModifiers, mergedDescriptions, mergedPublications, evidence, mergedBiocuration);
    }

    public HpoAnnotationModel getMergedModel() {
        HashMap termId2AnnotEntryListMap = new HashMap();
        for (HpoAnnotationEntry entry : this.entryList) {
            termId2AnnotEntryListMap.putIfAbsent(entry.getPhenotypeId(), new ArrayList());
            ((List)termId2AnnotEntryListMap.get(entry.getPhenotypeId())).add(entry);
        }
        ArrayList<HpoAnnotationEntry> builder = new ArrayList<HpoAnnotationEntry>();
        for (TermId tid : termId2AnnotEntryListMap.keySet()) {
            List entrylist = (List)termId2AnnotEntryListMap.get(tid);
            if (entrylist.size() == 1) {
                builder.add((HpoAnnotationEntry)entrylist.get(0));
                continue;
            }
            boolean mergable = true;
            if (this.divergentNegation(entrylist)) {
                mergable = false;
            } else if (this.divergentSex(entrylist)) {
                mergable = false;
            } else if (this.divergentOnset(entrylist)) {
                mergable = false;
            }
            if (mergable) {
                HpoAnnotationEntry merged = this.mergeEntries(entrylist);
                builder.add(merged);
                continue;
            }
            builder.addAll(entrylist);
        }
        return new HpoAnnotationModel(this.basename, List.copyOf(builder));
    }

    public TermId getDiseaseId() {
        HpoAnnotationEntry entry = this.entryList.iterator().next();
        return TermId.of((String)entry.getDiseaseID());
    }

    public String getDiseaseName() {
        return this.entryList.stream().map(HpoAnnotationEntry::getDiseaseName).findAny().orElse("n/a");
    }

    public void addInheritanceEntryCollection(Collection<HpoAnnotationEntry> entries) {
        ArrayList<HpoAnnotationEntry> builder = new ArrayList<HpoAnnotationEntry>();
        builder.addAll(this.entryList);
        builder.addAll(entries);
        this.entryList = List.copyOf(builder);
    }

    private static enum Database {
        OMIM,
        DECIPHER,
        UNKNOWN;

    }
}

