/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoFrequency;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoAnnotationLine {
    private static final String DEFAULT_FREQUENCY_STRING = "n/a";
    private static final String EMPTY_STRING = "";
    private boolean valid_number_of_fields = true;
    private static final String[] headerFields = new String[]{"DatabaseID", "DiseaseName", "Qualifier", "HPO_ID", "Reference", "Evidence", "Onset", "Frequency", "Sex", "Modifier", "Aspect", "Biocuration"};
    private final String databaseId;
    private final String databaseObjectName;
    private final boolean isNegated;
    private final String phenotypeId;
    private final String publication;
    private final String evidence;
    private final String onsetId;
    private final String frequency;
    private final String sex;
    private final String modifiers;
    private final String aspect;
    private final String biocuration;

    private HpoAnnotationLine(String line) throws PhenolException {
        String[] fields = line.split("\t");
        if (fields.length != headerFields.length) {
            this.valid_number_of_fields = false;
            throw new PhenolException("[phenol:ERROR] Annotation line with " + fields.length + "fields: \"" + line + "\"");
        }
        this.databaseId = fields[0];
        this.databaseObjectName = fields[1];
        this.isNegated = fields[2].equalsIgnoreCase("NOT");
        this.phenotypeId = fields[3];
        this.publication = fields[4];
        this.evidence = fields[5];
        this.onsetId = fields[6];
        this.frequency = fields[7];
        this.sex = fields[8];
        this.modifiers = fields[9];
        this.aspect = fields[10];
        this.biocuration = fields[11];
    }

    static HpoAnnotationLine constructFromString(String line) throws PhenolException {
        try {
            return new HpoAnnotationLine(line);
        }
        catch (PhenolException e) {
            throw new PhenolException(String.format("Exception [%s] parsing line: %s", e.getMessage(), line));
        }
    }

    static boolean isValidHeaderLine(String line) throws PhenolException {
        String[] fields = line.split("\t");
        if (fields.length != headerFields.length) {
            String msg = String.format("Expected %d fields in header line but got %d", headerFields.length, fields.length);
            throw new PhenolException(msg);
        }
        for (int i = 0; i < headerFields.length; ++i) {
            if (fields[i].equals(headerFields[i])) continue;
            String msg = String.format("Expected header field %d to be %s but got %s", i, headerFields[i], fields[i]);
            throw new PhenolException(msg);
        }
        return true;
    }

    final String getDiseaseId() {
        return this.databaseId;
    }

    Optional<TermId> getDiseaseTermId() {
        if (this.databaseId.startsWith("OMIM") || this.databaseId.startsWith("ORPHA") || this.databaseId.startsWith("DECIPHER")) {
            return Optional.of(TermId.of((String)this.databaseId));
        }
        return Optional.empty();
    }

    String getPhenotypeId() {
        return this.phenotypeId;
    }

    String getOnsetId() {
        return this.onsetId;
    }

    String getFrequency() {
        return this.frequency;
    }

    String getSex() {
        return this.sex;
    }

    String modifiers() {
        return this.modifiers;
    }

    List<String> getPublication() {
        if (this.publication == null || this.publication.isEmpty()) {
            return List.of();
        }
        String[] tokens = this.publication.split(";");
        ArrayList<String> builder = new ArrayList<String>(tokens.length);
        for (String a : tokens) {
            builder.add(a.trim());
        }
        return Collections.unmodifiableList(builder);
    }

    String getEvidence() {
        return this.evidence;
    }

    String getBiocuration() {
        return this.biocuration;
    }

    String getDatabaseObjectName() {
        return this.databaseObjectName;
    }

    String getAspect() {
        return this.aspect;
    }

    boolean isNOT() {
        return this.isNegated;
    }

    boolean hasValidNumberOfFields() {
        return this.valid_number_of_fields;
    }

    @Deprecated
    static HpoAnnotation toHpoAnnotation(HpoAnnotationLine line, Ontology ontology) {
        throw new RuntimeException("Not supported anymore!");
    }

    private static List<TermId> getModifiers(String lst) {
        if (lst == null || lst.isEmpty()) {
            return List.of();
        }
        String[] modifierTermStrings = lst.split(";");
        ArrayList<TermId> builder = new ArrayList<TermId>(modifierTermStrings.length);
        for (String mt : modifierTermStrings) {
            TermId mtId = TermId.of((String)mt.trim());
            builder.add(mtId);
        }
        return Collections.unmodifiableList(builder);
    }

    private static double getFrequency(String freq, Ontology ontology) {
        if (freq == null || freq.isEmpty()) {
            return HpoFrequency.OBLIGATE.frequency();
        }
        int i = freq.indexOf(37);
        if (i > 0) {
            return 0.01 * Double.parseDouble(freq.substring(0, i));
        }
        i = freq.indexOf(47);
        if (i > 0 && freq.length() > i + 1) {
            int n = Integer.parseInt(freq.substring(0, i));
            int m = Integer.parseInt(freq.substring(i + 1));
            return (double)n / (double)m;
        }
        try {
            TermId tid = HpoAnnotationLine.string2TermId(freq, ontology);
            if (tid != null) {
                try {
                    return HpoFrequency.fromTermId(tid).frequency();
                }
                catch (IllegalArgumentException e) {
                    return HpoFrequency.OBLIGATE.frequency();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return HpoFrequency.OBLIGATE.frequency();
    }

    private static TermId string2TermId(String hp, Ontology ontology) {
        if (!hp.startsWith("HP:")) {
            return null;
        }
        TermId tid = TermId.of((String)hp);
        if (ontology.getTermMap().containsKey(tid)) {
            return ((Term)ontology.getTermMap().get(tid)).id();
        }
        return null;
    }

    public String toString() {
        CharSequence[] fields = new String[]{this.databaseId, this.databaseObjectName, this.phenotypeId, this.onsetId == null ? EMPTY_STRING : this.onsetId, this.frequency, this.sex, this.isNegated ? "NOT" : EMPTY_STRING, this.aspect, this.modifiers, this.publication, this.evidence, this.biocuration};
        return String.join((CharSequence)"\t", fields);
    }
}

