/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseases;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderDefault;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.ontology.data.Ontology;

public interface HpoDiseaseLoader {
    public static HpoDiseaseLoader of(Ontology hpo) {
        return HpoDiseaseLoader.of(hpo, HpoDiseaseLoaderOptions.defaultOptions());
    }

    public static HpoDiseaseLoader of(Ontology hpo, HpoDiseaseLoaderOptions options) {
        return new HpoDiseaseLoaderDefault(hpo, options);
    }

    public HpoDiseases load(InputStream var1) throws IOException;

    default public HpoDiseases load(Path path) throws IOException {
        try (BufferedInputStream is = HpoDiseaseLoader.openForReading(path);){
            HpoDiseases hpoDiseases = this.load(is);
            return hpoDiseases;
        }
    }

    private static BufferedInputStream openForReading(Path path) throws IOException {
        InputStream is = Files.newInputStream(path, new OpenOption[0]);
        if (path.toFile().getName().endsWith("gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedInputStream(is);
    }
}

