/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.Sex;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.EvidenceCode;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationMetadata;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseases;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoOnset;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseData;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoader;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.constants.hpo.HpoClinicalModifierTermIds;
import org.monarchinitiative.phenol.constants.hpo.HpoModeOfInheritanceTermIds;
import org.monarchinitiative.phenol.constants.hpo.HpoSubOntologyRootTermIds;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HpoDiseaseLoaderDefault
implements HpoDiseaseLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HpoDiseaseLoaderDefault.class);
    private static final Pattern HPO_PATTERN = Pattern.compile("HP:\\d{7}");
    private static final Pattern RATIO_PATTERN = Pattern.compile("(?<numerator>\\d+)/(?<denominator>\\d+)");
    private static final Pattern PERCENTAGE_PATTERN = Pattern.compile("(?<value>\\d+\\.?(\\d+)?)%");
    private final int cohortSize;
    private final boolean salvageNegatedFrequencies;
    private final Set<String> databasePrefixes;
    private final Set<TermId> clinicalCourseSubHierarchy;
    private final Set<TermId> inheritanceSubHierarchy;

    HpoDiseaseLoaderDefault(Ontology hpo, HpoDiseaseLoaderOptions options) {
        Objects.requireNonNull(hpo, "HPO ontology must not be null.");
        Objects.requireNonNull(options, "Options must not be null.");
        this.cohortSize = options.cohortSize();
        this.salvageNegatedFrequencies = options.salvageNegatedFrequencies();
        this.databasePrefixes = options.includedDatabases().stream().map(DiseaseDatabase::prefix).collect(Collectors.toUnmodifiableSet());
        this.clinicalCourseSubHierarchy = hpo.containsTerm(HpoClinicalModifierTermIds.CLINICAL_COURSE) ? hpo.subOntology(HpoClinicalModifierTermIds.CLINICAL_COURSE).getNonObsoleteTermIds() : Set.of();
        this.inheritanceSubHierarchy = hpo.containsTerm(HpoModeOfInheritanceTermIds.INHERITANCE_ROOT) ? hpo.subOntology(HpoModeOfInheritanceTermIds.INHERITANCE_ROOT).getNonObsoleteTermIds() : Set.of();
    }

    @Override
    public HpoDiseases load(InputStream is) throws IOException {
        Map<TermId, List<HpoAnnotationLine>> disease2AnnotLineMap = this.groupLinesByDiseaseId(is);
        List<HpoDisease> diseases = disease2AnnotLineMap.entrySet().stream().map(entry -> this.assembleHpoDisease((TermId)entry.getKey(), (Iterable)entry.getValue())).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
        return HpoDiseases.of(diseases);
    }

    private Map<TermId, List<HpoAnnotationLine>> groupLinesByDiseaseId(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        HashMap<TermId, List<HpoAnnotationLine>> annotationLinesByDiseaseId = new HashMap<TermId, List<HpoAnnotationLine>>();
        String line = reader.readLine();
        while (line != null) {
            block5: {
                if (!line.startsWith("#")) {
                    HpoAnnotationLine annotationLine;
                    try {
                        annotationLine = HpoAnnotationLine.constructFromString(line);
                    }
                    catch (PhenolException e) {
                        LOGGER.warn("Error {} while parsing line: {}", (Object)e.getMessage(), (Object)line);
                        break block5;
                    }
                    TermId diseaseId = TermId.of((String)annotationLine.getDiseaseId());
                    if (this.databasePrefixes.contains(diseaseId.getPrefix())) {
                        annotationLinesByDiseaseId.computeIfAbsent(diseaseId, k -> new ArrayList()).add(annotationLine);
                    }
                }
            }
            line = reader.readLine();
        }
        return annotationLinesByDiseaseId;
    }

    private Optional<HpoDisease> assembleHpoDisease(TermId diseaseId, Iterable<HpoAnnotationLine> annotationLines) {
        Optional<HpoDiseaseData> diseaseDataOptional = this.parseDiseaseData(annotationLines);
        if (diseaseDataOptional.isEmpty()) {
            return Optional.empty();
        }
        HpoDiseaseData diseaseData = diseaseDataOptional.get();
        List<HpoAnnotation> phenotypes = diseaseData.phenotypes();
        HpoOnset onset = HpoDiseaseLoaderDefault.parseGlobalDiseaseOnset(diseaseData.clinicalCourseTerms(), phenotypes);
        Map<TermId, List<HpoAnnotation>> phenotypeById = phenotypes.stream().collect(Collectors.groupingBy(HpoAnnotation::id));
        List<HpoDiseaseAnnotation> diseaseAnnotations = phenotypeById.entrySet().stream().map(entry -> HpoDiseaseLoaderDefault.toDiseaseAnnotation((TermId)entry.getKey(), (List)entry.getValue())).collect(Collectors.toUnmodifiableList());
        return Optional.of(HpoDisease.of(diseaseId, diseaseData.diseaseName(), onset, diseaseAnnotations, Collections.unmodifiableList(diseaseData.modesOfInheritance())));
    }

    private Optional<HpoDiseaseData> parseDiseaseData(Iterable<HpoAnnotationLine> annotationLines) {
        ArrayList<HpoAnnotation> phenotypes = new ArrayList<HpoAnnotation>();
        LinkedList<TermId> modesOfInheritance = new LinkedList<TermId>();
        ArrayList<TermId> clinicalModifierListBuilder = new ArrayList<TermId>();
        ArrayList<TermId> clinicalCourse = new ArrayList<TermId>();
        String diseaseName = null;
        for (HpoAnnotationLine line : annotationLines) {
            TermId phenotypeId;
            if (line.getDatabaseObjectName() != null) {
                diseaseName = line.getDatabaseObjectName();
            }
            try {
                phenotypeId = TermId.of((String)line.getPhenotypeId());
            }
            catch (PhenolRuntimeException e) {
                LOGGER.warn("Non-parsable phenotype term `{}`: {}", (Object)line.getPhenotypeId(), (Object)e.getMessage());
                continue;
            }
            if (this.inheritanceSubHierarchy.contains(phenotypeId)) {
                modesOfInheritance.add(phenotypeId);
                continue;
            }
            if (this.clinicalCourseSubHierarchy.contains(phenotypeId)) {
                clinicalCourse.add(phenotypeId);
                continue;
            }
            if (phenotypeId.equals((Object)HpoSubOntologyRootTermIds.CLINICAL_MODIFIER)) {
                clinicalModifierListBuilder.add(phenotypeId);
                continue;
            }
            try {
                phenotypes.add(this.createHpoAnnotation(phenotypeId, line));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Non-parsable phenotype entry `{}`: {}", (Object)line, (Object)e.getMessage());
            }
        }
        return Optional.of(new HpoDiseaseData(diseaseName, phenotypes, modesOfInheritance, clinicalModifierListBuilder, clinicalCourse));
    }

    private HpoAnnotation createHpoAnnotation(TermId phenotypeId, HpoAnnotationLine line) throws IllegalArgumentException {
        AnnotationFrequency annotationFrequency = this.parseFrequency(line.isNOT(), line.getFrequency());
        HpoOnset onset = HpoOnset.fromHpoIdString(line.getOnsetId()).orElse(null);
        List<TermId> modifiers = Arrays.stream(line.modifiers().split(";")).filter(token -> !token.isBlank()).map(TermId::of).collect(Collectors.toList());
        List<String> citations = line.getPublication();
        EvidenceCode evidenceCode = EvidenceCode.parse(line.getEvidence());
        Sex sex = Sex.parse(line.getSex()).orElse(null);
        return HpoAnnotation.of(phenotypeId, annotationFrequency, onset, modifiers, citations, evidenceCode, sex);
    }

    private AnnotationFrequency parseFrequency(boolean isNegated, String frequency) throws IllegalArgumentException {
        Matcher matcher;
        boolean notDone = true;
        int numerator = -1;
        int denominator = -1;
        if ("".equals(frequency)) {
            numerator = isNegated ? 0 : 1;
            denominator = 1;
            return AnnotationFrequency.of(Ratio.of(numerator, denominator));
        }
        if (HPO_PATTERN.matcher(frequency).matches()) {
            HpoFrequency hpoFrequency = HpoFrequency.fromTermId(TermId.of((String)frequency));
            int hpoApproximate = Math.round(hpoFrequency.frequency() * (float)this.cohortSize);
            numerator = isNegated ? 0 : hpoApproximate;
            denominator = this.cohortSize;
            notDone = false;
        }
        if (notDone && (matcher = RATIO_PATTERN.matcher(frequency)).matches()) {
            denominator = Integer.parseInt(matcher.group("denominator"));
            int i = Integer.parseInt(matcher.group("numerator"));
            if (isNegated) {
                if (denominator == 0) {
                    denominator = this.cohortSize;
                }
                numerator = i == 0 && this.salvageNegatedFrequencies ? 0 : denominator - i;
            } else {
                numerator = i;
            }
            notDone = false;
        }
        if (notDone && (matcher = PERCENTAGE_PATTERN.matcher(frequency)).matches()) {
            float percentage = Float.parseFloat(matcher.group("value"));
            numerator = Math.round(percentage * (float)this.cohortSize / 100.0f);
            denominator = this.cohortSize;
            notDone = false;
        }
        if (notDone) {
            throw new IllegalArgumentException();
        }
        return AnnotationFrequency.of(Ratio.of(numerator, denominator));
    }

    private static HpoOnset parseGlobalDiseaseOnset(List<TermId> termIds, List<HpoAnnotation> phenotypes) {
        Optional<HpoOnset> earliest = termIds.stream().map(HpoOnset::fromTermId).flatMap(Optional::stream).min(Comparator.comparing(a -> a, TemporalInterval::compare));
        if (earliest.isPresent()) {
            return earliest.get();
        }
        HpoOnset onset = null;
        for (HpoAnnotation phenotype : phenotypes) {
            Optional<HpoOnset> onsetOptional = phenotype.onset();
            if (!onsetOptional.isPresent()) continue;
            HpoOnset candidate = onsetOptional.get();
            if (onset == null) {
                onset = candidate;
                continue;
            }
            int result = TemporalInterval.compare(candidate, onset);
            if (result >= 0) continue;
            onset = candidate;
        }
        return onset;
    }

    private static HpoDiseaseAnnotation toDiseaseAnnotation(TermId phenotypeId, List<HpoAnnotation> annotations) {
        List<HpoDiseaseAnnotationMetadata> metadata = annotations.stream().map(HpoDiseaseLoaderDefault::toHpoDiseaseAnnotationMetadata).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
        return HpoDiseaseAnnotation.of(phenotypeId, metadata);
    }

    private static Optional<HpoDiseaseAnnotationMetadata> toHpoDiseaseAnnotationMetadata(HpoAnnotation annotation) {
        return Optional.of(HpoDiseaseAnnotationMetadata.of(annotation.onset().map(o -> TemporalInterval.openEnd(o.start())).orElse(null), annotation.annotationFrequency(), annotation.modifiers(), annotation.sex()));
    }
}

